/*
 * Copyright 2019 chunaev.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ru.ilb.jfunction.runtime;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Paths;
import ru.ilb.jfunction.streams.InputStreamToBytesFunction;
import ru.ilb.jfunction.streams.InputStreamToStringFunction;

/**
 *
 * @author slavb
 */
public class RuntimeFunction implements ByteFunction {

    private final String[] command;

    private Process p;

    public RuntimeFunction(URI command) {
        File commandFile = Paths.get(command.getPath()).toFile();
        if (!commandFile.exists()) {
            throw new IllegalArgumentException(commandFile.toString() + " does not exists");
        }
        if (!commandFile.canExecute()) {
            throw new IllegalArgumentException(commandFile.toString() + " not executable");
        }
        this.command = new String[]{commandFile.toString()};
    }

    public RuntimeFunction(String... command) {
        this.command = command;
    }

    @Override
    public byte[] apply(byte[] t) {

        ProcessBuilder pb = new ProcessBuilder(command);
        byte[] output = null;
        try {
            p = pb.start();

            try (OutputStream stdin = p.getOutputStream()) {
                stdin.write(t);
            }
            output = InputStreamToBytesFunction.INSTANCE.apply(p.getInputStream());

            int exitCode = p.waitFor();
            switch (exitCode) {
                case 127:
                    throw new IllegalArgumentException(command[0] + " does not exist");
                case 0:
                    break;
                default:
                    StringBuilder sb = new StringBuilder();
                    sb.append("Wrong command exit code ");
                    sb.append(exitCode);
                    sb.append('\n');
                    sb.append(new String(output));
                    sb.append('\n');
                    sb.append(InputStreamToStringFunction.INSTANCE.apply(p.getErrorStream()));
                    throw new RuntimeException(sb.toString());
            }

        } catch (IOException | InterruptedException ex) {
            throw new RuntimeException(ex.getMessage());
        }

        return output;
    }

}
