/*
 * Decompiled with CFR 0.152.
 */
package ru.ilb.jfunction.runtime;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Paths;
import ru.ilb.jfunction.runtime.ByteFunction;
import ru.ilb.jfunction.streams.InputStreamToBytesFunction;
import ru.ilb.jfunction.streams.InputStreamToStringFunction;

public class RuntimeFunction
implements ByteFunction {
    private final String[] command;
    private Process p;

    public RuntimeFunction(URI command) {
        File commandFile = Paths.get(command.getPath(), new String[0]).toFile();
        if (!commandFile.exists()) {
            throw new IllegalArgumentException(commandFile.toString() + " does not exists");
        }
        if (!commandFile.canExecute()) {
            throw new IllegalArgumentException(commandFile.toString() + " not executable");
        }
        this.command = new String[]{commandFile.toString()};
    }

    public RuntimeFunction(String ... command) {
        this.command = command;
    }

    @Override
    public byte[] apply(byte[] t) {
        ProcessBuilder pb = new ProcessBuilder(this.command);
        byte[] output = null;
        try {
            this.p = pb.start();
            try (OutputStream stdin = this.p.getOutputStream();){
                stdin.write(t);
            }
            output = (byte[])InputStreamToBytesFunction.INSTANCE.apply((Object)this.p.getInputStream());
            int exitCode = this.p.waitFor();
            switch (exitCode) {
                case 127: {
                    throw new IllegalArgumentException(this.command[0] + " does not exist");
                }
                case 0: {
                    break;
                }
                default: {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Wrong command exit code ");
                    sb.append(exitCode);
                    sb.append('\n');
                    sb.append(new String(output));
                    sb.append('\n');
                    sb.append((String)InputStreamToStringFunction.INSTANCE.apply((Object)this.p.getErrorStream()));
                    throw new RuntimeException(sb.toString());
                }
            }
        }
        catch (IOException | InterruptedException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return output;
    }
}

