package ru.ilb.jfunction.streams;

import com.google.auto.service.AutoService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * InputStream to String converter function default implementation using ByteArrayOutputStream
 * @author slavb
 */
@AutoService(InputStreamToStringFunction.class)
public class InputStreamToStringFunctionImpl implements InputStreamToStringFunction {

    @Override
    public String apply(InputStream t) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream()) {
            byte[] buffer = new byte[1024];
            int len;
            while ((len = t.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            out.flush();
            return out.toString();
        }
    }

}
