/*
 * Decompiled with CFR 0.152.
 */
package ru.ilug.bmapper;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import ru.ilug.bmapper.ByteMapper;
import ru.ilug.bmapper.ByteMapperAnalyzer;
import ru.ilug.bmapper.codec.ArrayCodec;
import ru.ilug.bmapper.codec.ByteCodec;
import ru.ilug.bmapper.codec.CharCodec;
import ru.ilug.bmapper.codec.DoubleCodec;
import ru.ilug.bmapper.codec.FloatCodec;
import ru.ilug.bmapper.codec.ObjectCodec;
import ru.ilug.bmapper.codec.ShortCodec;
import ru.ilug.bmapper.codec.StringCodec;
import ru.ilug.bmapper.codec.UUIDCodec;
import ru.ilug.bmapper.codec.ValueCodec;
import ru.ilug.bmapper.codec.VarIntCodec;
import ru.ilug.bmapper.codec.VarLongCodec;
import ru.ilug.bmapper.entity.ByteMapperEntity;
import ru.ilug.bmapper.exception.ByteMapperAnalyzeException;

public class ByteMapperContext {
    private final Map<Class<?>, ValueCodec> typeMap = new HashMap();
    private final Map<Class<?>, ByteMapperEntity> entityMap = new HashMap();
    private final Map<Integer, ByteMapperEntity> entityIdMap = new Int2ObjectOpenHashMap();
    private final ByteMapperAnalyzer analyzer = new ByteMapperAnalyzer(this);
    private final ByteMapper byteMapper = new ByteMapper(this);

    public ByteMapperContext() {
        this.registerValueCodec(new ByteCodec(), new ShortCodec(), new VarIntCodec(), new VarLongCodec(), new FloatCodec(), new DoubleCodec(), new StringCodec(), new CharCodec(), new UUIDCodec(), new ObjectCodec());
    }

    public void registerValueCodec(ValueCodec ... codecs) {
        for (ValueCodec valueCodec : codecs) {
            for (Class<?> valueClass : valueCodec.getProvidedValueClass()) {
                this.typeMap.put(valueClass, valueCodec);
            }
        }
    }

    public ByteMapperEntity registerAndGetEntity(Class<?> clazz) {
        ByteMapperEntity entity = this.entityMap.get(clazz);
        if (entity == null) {
            entity = this.analyzer.analyzeEntity(clazz);
            if (this.entityIdMap.containsKey(entity.getId())) {
                throw new ByteMapperAnalyzeException("Entity with id " + entity.getId() + " already exists");
            }
            this.entityMap.put(clazz, entity);
            this.entityIdMap.put(entity.getId(), entity);
        }
        return entity;
    }

    public ByteMapperEntity getEntityById(int id) {
        ByteMapperEntity entity = this.entityIdMap.get(id);
        if (entity == null) {
            throw new ByteMapperAnalyzeException("Entity with id " + id + " not found");
        }
        return entity;
    }

    public ValueCodec getCodecForClass(Class<?> clazz) {
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            return new ArrayCodec(this.getCodecForClass(componentType));
        }
        ValueCodec type = this.typeMap.get(clazz);
        if (type != null) {
            return type;
        }
        ByteMapperEntity entity = this.registerAndGetEntity(clazz);
        if (entity != null) {
            return this.typeMap.get(Object.class);
        }
        throw new ByteMapperAnalyzeException("Cannot find type for class " + String.valueOf(clazz));
    }

    @Generated
    public ByteMapper getByteMapper() {
        return this.byteMapper;
    }
}

