/*
 * Decompiled with CFR 0.152.
 */
package ru.ilug.bmapper;

import java.nio.ByteBuffer;
import java.util.Objects;
import lombok.Generated;
import ru.ilug.bmapper.ByteMapperContext;
import ru.ilug.bmapper.codec.ValueCodec;
import ru.ilug.bmapper.entity.ByteMapperEntity;
import ru.ilug.bmapper.entity.ByteMapperProperty;

public class ByteMapper {
    private final ByteMapperContext context;

    public Object read(ByteBuffer buffer) {
        int entityId = buffer.getInt();
        ByteMapperEntity entity = this.context.getEntityById(entityId);
        Object instance = entity.createInstance();
        this.readParameters(buffer, entity, instance);
        return instance;
    }

    private void readParameters(ByteBuffer buffer, ByteMapperEntity entity, Object instance) {
        int parameterCount = buffer.getInt();
        for (int i = 0; i < parameterCount; ++i) {
            int parameterId = buffer.getInt();
            ByteMapperProperty parameter = entity.getProperty(parameterId);
            ValueCodec codec = parameter.getCodec();
            Object value = codec.read(buffer, parameter.getClazz(), this.context, this);
            parameter.setValue(instance, value);
        }
    }

    public void write(ByteBuffer buffer, Object object) {
        ByteMapperEntity entity = this.context.registerAndGetEntity(object.getClass());
        buffer.putInt(entity.getId());
        this.writeParameters(buffer, entity, object);
    }

    private void writeParameters(ByteBuffer buffer, ByteMapperEntity entity, Object instance) {
        int count = 0;
        int countIndex = buffer.position();
        buffer.putInt(0);
        for (ByteMapperProperty parameter : entity.getProperties()) {
            Object value = parameter.getValue(instance);
            if (Objects.equals(value, parameter.getDefaultValue())) continue;
            buffer.putInt(parameter.getId());
            ValueCodec codec = parameter.getCodec();
            codec.write(buffer, this.context, this, value);
            ++count;
        }
        buffer.putInt(countIndex, count);
    }

    @Generated
    public ByteMapper(ByteMapperContext context) {
        this.context = context;
    }
}

