/*
 * Decompiled with CFR 0.152.
 */
package ru.ilug.bmapper.codec;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import lombok.Generated;
import ru.ilug.bmapper.ByteMapper;
import ru.ilug.bmapper.ByteMapperContext;
import ru.ilug.bmapper.codec.ValueCodec;
import ru.ilug.bmapper.util.ValueCodecUtil;

public class ArrayCodec
implements ValueCodec {
    private final ValueCodec codec;

    @Override
    public Class<?>[] getProvidedValueClass() {
        return new Class[]{Object[].class};
    }

    @Override
    public Object read(ByteBuffer buffer, Class<?> clazz, ByteMapperContext context, ByteMapper mapper) {
        Class<?> componentType = clazz.getComponentType();
        int length = ValueCodecUtil.readVarInt(buffer);
        Object array = Array.newInstance(componentType, length);
        for (int i = 0; i < length; ++i) {
            Object value = this.codec.read(buffer, componentType, context, mapper);
            Array.set(array, i, value);
        }
        return array;
    }

    @Override
    public void write(ByteBuffer buffer, ByteMapperContext context, ByteMapper mapper, Object value) {
        int length = Array.getLength(value);
        ValueCodecUtil.writeVarInt(buffer, length);
        for (int i = 0; i < length; ++i) {
            Object object = Array.get(value, i);
            this.codec.write(buffer, context, mapper, object);
        }
    }

    @Generated
    public ArrayCodec(ValueCodec codec) {
        this.codec = codec;
    }
}

