/*
 * Decompiled with CFR 0.152.
 */
package ru.ilug.bmapper.util;

import java.nio.ByteBuffer;

public class ValueCodecUtil {
    public static void writeVarInt(ByteBuffer buffer, int value) {
        while ((value & 0xFFFFFF80) != 0) {
            buffer.put((byte)(value & 0x7F | 0x80));
            value >>>= 7;
        }
        buffer.put((byte)(value & 0x7F));
    }

    public static int readVarInt(ByteBuffer buffer) {
        int value;
        block1: {
            value = 0;
            int position = 0;
            do {
                byte b = buffer.get();
                value |= (b & 0x7F) << position;
                if ((b & 0x80) == 0) break block1;
            } while ((position += 7) < 32);
            throw new IllegalArgumentException("VarInt is too long");
        }
        return value;
    }

    public static void writeVarLong(ByteBuffer buffer, long value) {
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            buffer.put((byte)(value & 0x7FL | 0x80L));
            value >>>= 7;
        }
        buffer.put((byte)(value & 0x7FL));
    }

    public static long readVarLong(ByteBuffer buffer) {
        long value;
        block1: {
            value = 0L;
            int position = 0;
            do {
                byte b = buffer.get();
                value |= (long)(b & 0x7F) << position;
                if ((b & 0x80) == 0) break block1;
            } while ((position += 7) < 64);
            throw new IllegalArgumentException("VarLong is too long");
        }
        return value;
    }
}

