/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.cucumber;

import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.util.Map;
import ru.mk.pump.commons.config.ConfigurationHelper;
import ru.mk.pump.commons.reporter.Reporter;
import ru.mk.pump.commons.utils.Verifier;
import ru.mk.pump.cucumber.CucumberConfig;
import ru.mk.pump.cucumber.Stand;
import ru.mk.pump.cucumber.plugin.CucumberMonitor;
import ru.mk.pump.web.browsers.Browsers;
import ru.mk.pump.web.common.WebItemsController;
import ru.mk.pump.web.common.WebReporter;
import ru.mk.pump.web.common.api.ItemsManager;
import ru.mk.pump.web.component.ComponentStaticManager;
import ru.mk.pump.web.configuration.ConfigurationHolder;
import ru.mk.pump.web.interpretator.rules.Pumpkin;
import ru.mk.pump.web.page.PageManager;
import ru.mk.pump.web.utils.TestVars;

public class CucumberCore
extends AbstractModule {
    private static final String DEFAULT_SYSTEM_ENV_NAME = "pump.cucumber.configuration.path";
    private static final String DEFAULT_CLASSPATH_RESOURCE = "pump.cucumber.properties";
    private static final CucumberCore INSTANCE = new CucumberCore();
    private final Map<String, Object> DEFAULT_TEST_VARS = ImmutableMap.builder().put((Object)"test_runner", (Object)"cucumber").put((Object)"true", (Object)true).put((Object)"false", (Object)false).build();
    private Stand standConfig;
    private final ConfigurationHelper<CucumberConfig> configHelper = new ConfigurationHelper("pump.cucumber.configuration.path", "pump.cucumber.properties", (Object)CucumberConfig.of());
    private final ThreadLocal<CucumberMonitor> cucumberMonitor = InheritableThreadLocal.withInitial(CucumberMonitor::newInactive);
    private final Browsers browsers = new Browsers();
    private final TestVars testVariables = TestVars.of(this.DEFAULT_TEST_VARS, (Reporter)this.getReporter());
    private volatile WebItemsController webController;

    public static CucumberCore instance() {
        return INSTANCE;
    }

    @Provides
    public CucumberMonitor getMonitor() {
        return this.cucumberMonitor.get();
    }

    public void setMonitor(CucumberMonitor monitor) {
        this.cucumberMonitor.set(monitor);
    }

    @Provides
    public Reporter getReporter() {
        return WebReporter.getReporter();
    }

    @Provides
    public Verifier getVerifier() {
        return WebReporter.getVerifier();
    }

    @Provides
    public WebItemsController getWebController() {
        if (this.webController == null) {
            ComponentStaticManager cManager = new ComponentStaticManager(this.browsers, ConfigurationHolder.get().getComponent().getPackages());
            PageManager pManager = new PageManager(this.browsers, ConfigurationHolder.get().getPage().getPackages());
            CucumberCore.INSTANCE.webController = new WebItemsController((ItemsManager)pManager, (ItemsManager)cManager, this.testVariables);
        }
        return this.webController;
    }

    @Provides
    public Pumpkin paramParser() {
        return Pumpkin.newParamParser((Map)this.testVariables.asMap());
    }

    @Provides
    public synchronized CucumberConfig getConfig() {
        if (this.configHelper.getActualConfig() == null) {
            return (CucumberConfig)this.configHelper.loadAuto();
        }
        return (CucumberConfig)this.configHelper.getActualConfig();
    }

    private CucumberCore() {
    }

    public void setStandConfig(Stand standConfig) {
        this.standConfig = standConfig;
    }

    @Provides
    public Stand getStandConfig() {
        return this.standConfig;
    }

    public ConfigurationHelper<CucumberConfig> getConfigHelper() {
        return this.configHelper;
    }

    @Provides
    public Browsers getBrowsers() {
        return this.browsers;
    }

    @Provides
    public TestVars getTestVariables() {
        return this.testVariables;
    }
}

