/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.cucumber.glue.other.hooks;

import cucumber.api.Scenario;
import java.util.Collection;
import lombok.NonNull;

public class TagHelper {
    public static final String BROWSER_RESTART = "@BrowserRestart";
    public static final String NO_SKIP = "@NoSkip";
    public static final String SKIP = "@Skip";
    private final Collection<String> tags;
    private Scenario scenario;

    public TagHelper(Scenario scenario) {
        this.scenario = scenario;
        this.tags = scenario.getSourceTagNames();
    }

    public boolean hasTag(@NonNull String tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked @NonNull but is null");
        }
        if (!tag.startsWith("@")) {
            tag = "@" + tag;
        }
        return this.tags.stream().anyMatch(tag::equalsIgnoreCase);
    }

    public boolean isSkip() {
        return this.hasTag(SKIP);
    }

    public boolean isNoSkip() {
        return this.hasTag(NO_SKIP);
    }

    public boolean isBrowserRestart() {
        return this.hasTag(BROWSER_RESTART);
    }

    public Scenario getScenario() {
        return this.scenario;
    }
}

