/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.cucumber.glue.other.hooks;

import cucumber.api.Scenario;
import cucumber.api.java.After;
import cucumber.api.java.Before;
import io.qameta.allure.Step;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.utils.DesktopScreenshoter;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.cucumber.CucumberCore;
import ru.mk.pump.cucumber.CucumberUtil;
import ru.mk.pump.cucumber.glue.other.hooks.TagHelper;
import ru.mk.pump.web.configuration.ConfigurationHolder;

public class WebHooks {
    private static final Logger log = LoggerFactory.getLogger(WebHooks.class);
    private static final DesktopScreenshoter DESKTOP_SCREENSHOTER = new DesktopScreenshoter();
    private static boolean beforeScenarioHook = CucumberCore.instance().getConfig().isBeforeScenarioHook();
    private static boolean afterScenarioHook = CucumberCore.instance().getConfig().isAfterScenarioHook();
    private final CucumberCore core = CucumberCore.instance();

    @Before(order=10)
    @Step(value="Before scenario '{scenario.testCase.pickleEvent.pickle.name}'")
    public void beforeScenarioDefault(Scenario scenario) {
        TagHelper tags = new TagHelper(scenario);
        this.checkPluginHook();
        this.skipHook(tags);
        if (beforeScenarioHook) {
            if (tags.isBrowserRestart()) {
                this.browserRestart();
            }
            this.screenHook("start");
            log.info("[HOOK] Before Scenario" + Strings.line() + CucumberUtil.toPrettyString(scenario) + Strings.line());
        }
    }

    @After(order=10)
    @Step(value="After scenario '{scenario.testCase.pickleEvent.pickle.name}'")
    public void afterScenarioDefault(Scenario scenario) {
        if (afterScenarioHook) {
            this.screenHook("finish");
            log.info("[HOOK] After Scenario" + Strings.line() + CucumberUtil.toPrettyString(scenario) + Strings.line());
        }
    }

    private void checkPluginHook() {
        this.core.getMonitor().checkPlugin();
    }

    private void screenHook(String status) {
        this.core.getReporter().attachments().screen("On scenario " + status, () -> DESKTOP_SCREENSHOTER.getScreen().orElse(null));
    }

    private void skipHook(TagHelper tagHelper) {
        if (tagHelper.isSkip()) {
            CucumberUtil.skipScenario(tagHelper.getScenario());
        } else {
            this.core.getMonitor().getLastFeature().ifPresent(feature -> {
                if (!feature.isOk() && !tagHelper.isNoSkip()) {
                    CucumberUtil.skipScenario(tagHelper.getScenario());
                }
            });
        }
    }

    private void browserRestart() {
        this.core.getBrowsers().closeCurrentThread();
        this.core.getBrowsers().newBrowser(ConfigurationHolder.get().getBrowserConfig());
    }

    public static void setBeforeScenarioHook(boolean beforeScenarioHook) {
        WebHooks.beforeScenarioHook = beforeScenarioHook;
    }

    public static void setAfterScenarioHook(boolean afterScenarioHook) {
        WebHooks.afterScenarioHook = afterScenarioHook;
    }
}

