/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.cucumber.glue.other.registry;

import io.cucumber.cucumberexpressions.ParameterByTypeTransformer;
import io.cucumber.datatable.dependency.com.fasterxml.jackson.databind.JavaType;
import io.cucumber.datatable.dependency.com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.cucumber.CucumberCore;
import ru.mk.pump.web.interpretator.items.Item;

public class PumpkinTransformer
implements ParameterByTypeTransformer {
    private static final Logger log = LoggerFactory.getLogger(PumpkinTransformer.class);
    private final String delimiter = ",";
    private final ObjectMapper objectMapper = new ObjectMapper();

    public Object transform(String fromValue, Type toValueType) {
        if (fromValue == null) {
            return this.parseNonPumpkin(null, toValueType);
        }
        fromValue = new StringSubstitutor(CucumberCore.instance().getTestVariables().getStringMap(), "${str:", "}").replace(fromValue);
        Queue<Item> items = this.getItems(fromValue);
        if (items.isEmpty()) {
            return null;
        }
        return this.parse(items, toValueType);
    }

    protected Queue<Item> getItems(String fromValue) {
        return CucumberCore.instance().paramParser().generateItems(fromValue);
    }

    protected Object parsePumpkin(Queue<Item> itemQueue, Type expectedType) {
        Object res;
        if (itemQueue.size() == 1) {
            res = itemQueue.poll().getSource();
        } else {
            StringBuilder str = new StringBuilder();
            for (Item item : itemQueue) {
                if (!(item.getSource() instanceof String)) continue;
                str.append(item.getSource());
            }
            res = str.toString();
        }
        return res;
    }

    protected Object parseNonPumpkin(String fromValue, Type expectedType) {
        JavaType javaType = this.objectMapper.constructType(expectedType);
        if (Boolean.TYPE.equals(expectedType) || Boolean.class.equals((Object)expectedType)) {
            if (StringUtils.equalsAny((CharSequence)fromValue, (CharSequence[])new CharSequence[]{"true", "\u0438\u0441\u0442\u0438\u043d\u0430"})) {
                return true;
            }
            if (StringUtils.equalsAny((CharSequence)fromValue, (CharSequence[])new CharSequence[]{"false", "\u043b\u043e\u0436\u044c"})) {
                return false;
            }
            return !Strings.isBlank((String)fromValue);
        }
        if (javaType.isTypeOrSubTypeOf(List.class)) {
            return Arrays.stream(fromValue.split(",")).map(i -> this.objectMapper.convertValue(i, javaType.getContentType())).collect(Collectors.toList());
        }
        return this.objectMapper.convertValue((Object)fromValue, javaType);
    }

    private Object parse(Queue<Item> itemQueue, Type expectedType) {
        Object res = this.parsePumpkin(itemQueue, expectedType);
        if (res instanceof String) {
            res = this.parseNonPumpkin((String)res, expectedType);
        }
        log.debug("[TRANSFORMER] Result : '{}'", res);
        return res;
    }
}

