/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.cucumber.glue.step.en;

import cucumber.api.java.en.Given;
import org.openqa.selenium.Alert;
import ru.mk.pump.cucumber.CucumberCore;
import ru.mk.pump.cucumber.glue.AbstractSteps;
import ru.mk.pump.web.browsers.Browser;
import ru.mk.pump.web.browsers.configuration.BrowserConfig;
import ru.mk.pump.web.browsers.configuration.BrowserType;
import ru.mk.pump.web.configuration.ConfigurationHolder;

public class BrowserSteps
extends AbstractSteps {
    @Given(value="^Browser - new '(.+)'$")
    public void newBrowser(BrowserType browserType) {
        BrowserConfig config = ConfigurationHolder.get().getBrowserConfig();
        config.setType(browserType);
        this.core().getBrowsers().newBrowser(config).start();
    }

    @Given(value="^Browser - reset frame$")
    public void setRootFrame() {
        CucumberCore.instance().getBrowsers().get().actions().switchToRootFrame();
    }

    @Given(value="^Browser - restart$")
    public void restart() {
        if (!CucumberCore.instance().getBrowsers().has()) {
            throw new IllegalStateException("You have to startScenario at least one browser before restart");
        }
        Browser browser = CucumberCore.instance().getBrowsers().get();
        browser.close();
        this.core().getBrowsers().newBrowser(browser.getConfig()).start();
    }

    @Given(value="^Browser - close current$")
    public void closeCurrent() {
        if (this.core().getBrowsers().has()) {
            this.core().getBrowsers().get().close();
        }
    }

    @Given(value="^Browser - stop all in thread$")
    public void closeAllCurrentThread() {
        if (this.core().getBrowsers().has()) {
            this.core().getBrowsers().closeCurrentThread();
        }
    }

    @Given(value="^Browser - stop anyone$")
    public void closeAll() {
        this.core().getBrowsers().close();
    }

    @Given(value="^Alert - save text to 'result'$")
    public void alertText() {
        Alert alert = this.core().getBrowsers().get().actions().alert(5);
        this.core().getTestVariables().putResult((Object)alert.getText());
    }

    @Given(value="^Alert - accept$")
    public void alertAccept() {
        this.core().getBrowsers().get().actions().alert(5).accept();
    }

    @Given(value="^Alert - dismiss$")
    public void alertDismiss() {
        this.core().getBrowsers().get().actions().alert(5).dismiss();
    }
}

