/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.cucumber.glue.step.en;

import cucumber.api.java.en.Given;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.helpers.Parameter;
import ru.mk.pump.cucumber.glue.AbstractSteps;
import ru.mk.pump.web.common.WebItemsController;
import ru.mk.pump.web.constants.ElementParams;
import ru.mk.pump.web.elements.api.Element;
import ru.mk.pump.web.elements.api.part.Clickable;
import ru.mk.pump.web.elements.api.part.Editable;
import ru.mk.pump.web.elements.internal.State;
import ru.mk.pump.web.page.BasePage;

public class PageSteps
extends AbstractSteps {
    private static final Logger log = LoggerFactory.getLogger(PageSteps.class);
    private final WebItemsController controller = this.core().getWebController();

    @Given(value="^Page - execute '(.+)'$")
    public void pageExecute(String pumpkinExpression) {
        this.core().getWebController().executeOnCurrentPage(pumpkinExpression);
    }

    @Given(value="^Page - check current page '(.+)'$")
    public void pageSet(String pumpkinExpression) {
        this.core().getWebController().initPage(pumpkinExpression).check();
    }

    @Given(value="^Page - open '(.+)'$")
    public void pageOpen(String pumpkinExpression) {
        this.core().getWebController().initPage(pumpkinExpression).open();
    }

    @Given(value="^Page - get element '(.+)' and set '(.+)'$")
    public void pageElementSet(String pumpkinExpression, String argument) {
        ((Editable)WebItemsController.cast((Object)this.controller.executeOnCurrentPage(pumpkinExpression), Editable.class)).set(new Parameter[]{ElementParams.EDITABLE_SET_STRING.withValue((Object)argument)});
    }

    @Given(value="^Page - get element '(.+)' and save text to 'result'$")
    public void pageElementText(String pumpkinExpression) {
        this.core().getTestVariables().putResult((Object)((Element)WebItemsController.cast((Object)this.controller.executeOnCurrentPage(pumpkinExpression), Element.class)).getText());
    }

    @Given(value="^Page - get element '(.+)' and click")
    public void pageElementClick(String pumpkinExpression) {
        ((Clickable)WebItemsController.cast((Object)this.controller.executeOnCurrentPage(pumpkinExpression), Clickable.class)).click();
    }

    @Given(value="^Page - get element '(.+)' and check state 'is displayed'$")
    public void pageElementStateDisplayed(String pumpkinExpression) {
        State res = ((Element)WebItemsController.cast((Object)this.controller.executeOnCurrentPage(pumpkinExpression), Element.class)).isDisplayed();
        this.core().getVerifier().checkTrue(res.name(), res.result().isSuccess(), new String[]{res.toPrettyString()});
    }

    @Given(value="^Page - get element '(.+)' and check state 'is NOT displayed'$")
    public void pageElementStateNotDisplayed(String pumpkinExpression) {
        State res = ((Element)WebItemsController.cast((Object)this.controller.executeOnCurrentPage(pumpkinExpression), Element.class)).isNotDisplayed();
        this.core().getVerifier().checkTrue(res.name(), res.result().isSuccess(), new String[]{res.toPrettyString()});
    }

    @Given(value="^Page - get text and save to 'result'$")
    public void pageText() {
        if (this.controller.getPageManager().getCurrent() == null) {
            throw new IllegalStateException("You must to init any page in controller");
        }
        this.core().getTestVariables().putResult((Object)((BasePage)this.controller.getPageManager().getCurrent()).getText());
    }
}

