/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.cucumber.glue.step.en;

import com.google.inject.Inject;
import cucumber.api.java.en.Given;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.utils.Collators;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.commons.utils.Verifier;
import ru.mk.pump.cucumber.glue.AbstractSteps;

public class VerifySteps
extends AbstractSteps {
    private static final Logger log = LoggerFactory.getLogger(VerifySteps.class);
    private static final String MSG = "Cucumber verification step";
    private final Verifier verifier;

    @Inject
    public VerifySteps(Verifier verifier) {
        this.verifier = verifier;
    }

    @Given(value="^Verify - equals object expected '(.+)' and actual '(.+)'$")
    public void equalsObject(Object expect, Object actual) {
        this.verifier.equals(MSG, expect, actual, new String[0]);
    }

    @Given(value="^Verify - NOT equals object expected '(.+)' and actual '(.+)'$")
    public void notEqualsObject(Object expect, Object actual) {
        this.verifier.notEquals(MSG, expect, actual, new String[0]);
    }

    @Given(value="^Verify - equals string expected '(.+)' and actual '(.+)'$")
    public void equalsString(String expect, String actual) {
        this.verifier.equals(MSG, Strings.liteNormalize((String)expect), Strings.liteNormalize((String)actual), new String[0]);
    }

    @Given(value="^Verify - NOT equals string expected '(.+)' and actual '(.+)'$")
    public void notEqualsString(String expect, String actual) {
        this.verifier.notEquals(MSG, Strings.liteNormalize((String)expect), Strings.liteNormalize((String)actual), new String[0]);
    }

    @Given(value="^Verify - equals long expected '(.+)' and actual '(.+)'$")
    public void equalsNumber(long expect, long actual) {
        this.verifier.equals(MSG, (Object)expect, (Object)actual, new String[0]);
    }

    @Given(value="^Verify - NOT equals long expected '(.+)' and actual '(.+)'$")
    public void notEqualsNumber(long expect, long actual) {
        this.verifier.notEquals(MSG, (Object)expect, (Object)actual, new String[0]);
    }

    @Given(value="^Verify - equals list expected '(.+)' and actual '(.+)'$")
    public void equalsList(List<String> expect, List<String> actual) {
        this.verifier.listEquals(MSG, expect, actual, Collators.equals(), null);
    }

    @Given(value="^Verify - contains string expected '(.+)' to actual '(.+)'$")
    public void contains(String expect, String actual) {
        this.verifier.contains(MSG, Strings.liteNormalize((String)expect), Strings.liteNormalize((String)actual), new String[0]);
    }

    @Given(value="^Verify - NOT contains string expected '(.+)' to actual '(.+)'$")
    public void notContains(String expect, String actual) {
        this.verifier.notContains(MSG, Strings.liteNormalize((String)expect), Strings.liteNormalize((String)actual), new String[0]);
    }

    @Given(value="^Verify - contains list expected '(.+)' and actual '(.+)'$")
    public void containsList(List<String> expect, List<String> actual) {
        this.verifier.listStrictContains(MSG, expect, actual, Collators.liteNormalizeContains(), null);
    }

    @Given(value="^Verify - actual '(.+)' is true$")
    public void isTrue(boolean actual) {
        this.verifier.checkTrue(MSG, actual, new String[0]);
    }

    @Given(value="^Verify - actual '(.+)' is false$")
    public void isFalse(boolean actual) {
        this.verifier.checkFalse(MSG, actual, new String[0]);
    }
}

