/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.cucumber.glue.step.en;

import cucumber.api.java.en.Given;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.helpers.Parameter;
import ru.mk.pump.cucumber.glue.AbstractSteps;
import ru.mk.pump.web.common.WebItemsController;
import ru.mk.pump.web.component.BaseComponent;
import ru.mk.pump.web.constants.ElementParams;
import ru.mk.pump.web.elements.api.Element;
import ru.mk.pump.web.elements.api.part.Clickable;
import ru.mk.pump.web.elements.api.part.Editable;
import ru.mk.pump.web.elements.internal.State;

public class WindowSteps
extends AbstractSteps {
    private static final Logger log = LoggerFactory.getLogger(WindowSteps.class);
    private final WebItemsController controller = this.core().getWebController();

    @Given(value="^Window - check current window '(.+)'$")
    public void winSet(String pumpkinExpression) {
        this.core().getWebController().initComponent(pumpkinExpression).check();
    }

    @Given(value="^Window - get element '(.+)' and set '(.+)'$")
    public void winElementSet(String pumpkinExpression, String argument) {
        ((Editable)WebItemsController.cast((Object)this.controller.executeOnCurrentComponent(pumpkinExpression), Editable.class)).set(new Parameter[]{ElementParams.EDITABLE_SET_STRING.withValue((Object)argument)});
    }

    @Given(value="^Window - get element '(.+)' and click")
    public void winElementClick(String pumpkinExpression) {
        ((Clickable)WebItemsController.cast((Object)this.controller.executeOnCurrentComponent(pumpkinExpression), Clickable.class)).click();
    }

    @Given(value="^Window - get element '(.+)' and save text to 'result'$")
    public void winElementText(String pumpkinExpression) {
        this.core().getTestVariables().putResult((Object)((Element)WebItemsController.cast((Object)this.controller.executeOnCurrentComponent(pumpkinExpression), Element.class)).getText());
    }

    @Given(value="^Window - get element '(.+)' and check state 'is displayed'$")
    public void winElementStateDisplayed(String pumpkinExpression) {
        State res = ((Element)WebItemsController.cast((Object)this.controller.executeOnCurrentComponent(pumpkinExpression), Element.class)).isDisplayed();
        this.core().getVerifier().checkTrue(res.name(), res.result().isSuccess(), new String[]{res.toPrettyString()});
    }

    @Given(value="^Window - get element '(.+)' and check state 'is NOT displayed'$")
    public void winElementStateNotDisplayed(String pumpkinExpression) {
        State res = ((Element)WebItemsController.cast((Object)this.controller.executeOnCurrentComponent(pumpkinExpression), Element.class)).isNotDisplayed();
        this.core().getVerifier().checkTrue(res.name(), res.result().isSuccess(), new String[]{res.toPrettyString()});
    }

    @Given(value="^Window - execute '(.+)'$")
    public void pageExecute(String pumpkinExpression) {
        this.core().getWebController().executeOnCurrentComponent(pumpkinExpression);
    }

    @Given(value="^Window - get text and save to 'result'$")
    public void winText() {
        if (this.controller.getComponentManager().getCurrent() == null) {
            throw new IllegalStateException("You must to init any component in controller");
        }
        this.core().getTestVariables().putResult((Object)((BaseComponent)this.controller.getComponentManager().getCurrent()).getText());
    }
}

