/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.cucumber.glue.step.ru;

import cucumber.api.java.en.Given;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.helpers.Parameter;
import ru.mk.pump.commons.utils.Pre;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.cucumber.glue.AbstractSteps;
import ru.mk.pump.web.common.WebItemsController;
import ru.mk.pump.web.component.api.Component;
import ru.mk.pump.web.constants.ElementParams;
import ru.mk.pump.web.elements.api.Element;
import ru.mk.pump.web.elements.api.part.Clickable;
import ru.mk.pump.web.elements.api.part.Editable;
import ru.mk.pump.web.elements.internal.State;
import ru.mk.pump.web.interpretator.items.Method;
import ru.mk.pump.web.page.BasePage;
import ru.mk.pump.web.page.api.Page;

public class PageSteps
extends AbstractSteps {
    private static final Logger log = LoggerFactory.getLogger(PageSteps.class);
    private final WebItemsController controller = this.core().getWebController();

    @Given(value="^(\u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430|\u043e\u043a\u043d\u043e) (.+?) \u043e\u0442\u043a\u0440\u044b\u0442[\u0430\u043e] \u0443\u0441\u043f\u0435\u0448\u043d\u043e$")
    public void pageSet(String type, String pumpkinExpression) {
        if (PageSteps.isPage(type)) {
            this.controller.initPage(pumpkinExpression).check();
        } else {
            this.controller.initComponent(pumpkinExpression).check();
        }
    }

    @Given(value="^\u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443 (.+?) (?:\u0441\u043e\u0432\u0435\u0440\u0448\u0435\u043d|\u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d) \u043f\u0435\u0440\u0435\u0445\u043e\u0434( \u0438 \u043e\u043d\u0430 \u043e\u0442\u043a\u0440\u044b\u043b\u0430\u0441\u044c \u0443\u0441\u043f\u0435\u0448\u043d\u043e|)$")
    public void pageOpen(String pumpkinExpression, boolean check) {
        Page page = this.controller.initPage(pumpkinExpression);
        page.open();
        if (check) {
            page.check();
        }
    }

    @Given(value="^(\u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435|\u0432 \u043e\u043a\u043d\u0435) \u0432\u0435\u0441\u044c \u0442\u0435\u043a\u0441\u0442 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d \u0432 (.+?|result)$")
    public void pageText(String type, String key) {
        Component object = PageSteps.isPage(type) ? (Component)this.controller.getPageManager().getCurrent() : (Component)this.controller.getComponentManager().getCurrent();
        Pre.checkObjectNotNull((Object)object, BasePage.class, (String)"\u0421\u043d\u0430\u0447\u0430\u043b\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u0443\u0439\u0442\u0435 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443 \u0438\u043b\u0438 \u043e\u043a\u043d\u043e");
        this.core().getTestVariables().put(key, (Object)object.getText());
    }

    @Given(value="^(\u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435|\u0432 \u043e\u043a\u043d\u0435) \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u0430 '(.+?)'(?: \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d \u0432 (.+?|result))$")
    public void pageExecute(String type, String pumpkinExpression, String key) {
        Object object = this.getWebItem(type, pumpkinExpression);
        if (!Strings.isBlank((String)key)) {
            this.core().getTestVariables().put(key, object);
        }
    }

    @Given(value="^(\u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435|\u0432 \u043e\u043a\u043d\u0435) \u043d\u0430\u0439\u0434\u0435\u043d \u044d\u043b\u0435\u043c\u0435\u043d\u0442 '(.+?)' \u0438 (?:\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e|\u0432\u044b\u0431\u0440\u0430\u043d\u043e) \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 '(.+?)'$")
    public void pageElementSet(String type, String pumpkinExpression, String argument) {
        Object object = this.getWebItem(type, pumpkinExpression);
        ((Editable)WebItemsController.cast((Object)object, Editable.class)).set(new Parameter[]{ElementParams.EDITABLE_SET_STRING.withValue((Object)argument)});
    }

    @Given(value="^(\u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435|\u0432 \u043e\u043a\u043d\u0435) \u043d\u0430\u0439\u0434\u0435\u043d \u044d\u043b\u0435\u043c\u0435\u043d\u0442 '(.+?)' \u0438 \u043a\u043e\u043b-\u0432\u043e \u043f\u043e\u0434\u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043e \u0432 (.+?|result)$")
    public void pageElementListSize(String type, String pumpkinExpression, String key) {
        Object object = this.getWebItem(type, pumpkinExpression);
        this.core().getTestVariables().put(key, (Object)((List)WebItemsController.cast((Object)object, List.class)).size());
    }

    @Given(value="^(\u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435|\u0432 \u043e\u043a\u043d\u0435) \u043d\u0430\u0439\u0434\u0435\u043d \u044d\u043b\u0435\u043c\u0435\u043d\u0442 '(.+?)'(?: \u0442\u0435\u043a\u0441\u0442 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d \u0432 (.+?|result))$")
    public void pageElementText(String type, String pumpkinExpression, String key) {
        Object object = this.getWebItem(type, pumpkinExpression);
        this.core().getTestVariables().put(key, (Object)((Element)WebItemsController.cast((Object)object, Element.class)).getText());
    }

    @Given(value="^(\u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435|\u0432 \u043e\u043a\u043d\u0435) \u043d\u0430\u0439\u0434\u0435\u043d \u044d\u043b\u0435\u043c\u0435\u043d\u0442 '(.+?)' \u0438 \u0441\u043e\u0432\u0435\u0440\u0448\u0435\u043d (\u043a\u043b\u0438\u043a|\u0441\u043a\u0440\u043e\u043b\u043b)")
    public void pageElementClick(String type, String pumpkinExpression, String action) {
        Object object = this.getWebItem(type, pumpkinExpression);
        switch (action) {
            case "\u043a\u043b\u0438\u043a": {
                ((Clickable)WebItemsController.cast((Object)object, Clickable.class)).click();
                break;
            }
            case "\u0441\u043a\u0440\u043e\u043b\u043b": {
                ((Element)WebItemsController.cast((Object)object, Element.class)).scroll();
                break;
            }
            default: {
                this.operationTypeError(action);
            }
        }
    }

    @Given(value="^(\u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435|\u0432 \u043e\u043a\u043d\u0435) \u043d\u0430\u0439\u0434\u0435\u043d \u044d\u043b\u0435\u043c\u0435\u043d\u0442 '(.+?)'( \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d \u0441\u043a\u0440\u043e\u043b\u043b|) \u0438 \u043e\u043d (\u0432\u0438\u0434\u0435\u043d|\u043d\u0435 \u0432\u0438\u0434\u0435\u043d|\u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442|\u043d\u0435 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442|\u0432\u043a\u043b\u044e\u0447\u0435\u043d|\u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d)(?: \u0437\u0430 ([0-9]+?) \u0441\u0435\u043a|)$")
    public void pageElementStateDisplayed(String type, String pumpkinExpression, boolean scroll, String status, int timeout) {
        Object object = this.getWebItem(type, pumpkinExpression);
        Element element = (Element)WebItemsController.cast((Object)object, Element.class);
        Method method = new Method(status);
        if (timeout > 0) {
            method.addArg((Object)timeout);
        }
        if (scroll) {
            element.scroll();
        }
        State state = (State)WebItemsController.cast((Object)this.controller.callMethod((Object)element, method), State.class);
        this.core().getVerifier().checkTrue(state.name(), state.result().isSuccess(), new String[]{state.toPrettyString()});
    }

    private static boolean isPage(String string) {
        if (Strings.isBlank((String)string)) {
            return true;
        }
        return StringUtils.containsIgnoreCase((CharSequence)string, (CharSequence)"\u0441\u0442\u0440\u0430\u043d\u0438\u0446");
    }

    private Object getWebItem(String type, String pumpkinExpression) {
        if (PageSteps.isPage(type)) {
            return this.controller.executeOnCurrentPage(pumpkinExpression);
        }
        return this.controller.executeOnCurrentComponent(pumpkinExpression);
    }
}

