/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.cucumber.glue.step.ru;

import com.google.inject.Inject;
import cucumber.api.java.en.Given;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.utils.Collators;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.commons.utils.Verifier;
import ru.mk.pump.cucumber.glue.AbstractSteps;

public class VerifySteps
extends AbstractSteps {
    private static final Logger log = LoggerFactory.getLogger(VerifySteps.class);
    private static final String MSG = "Cucumber \u0448\u0430\u0433 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439";
    private final Verifier verifier;

    @Inject
    public VerifySteps(Verifier verifier) {
        this.verifier = verifier;
    }

    @Given(value="^\u043f\u0440\u043e\u0432\u0435\u0440\u0435\u043d\u043e, \u0447\u0442\u043e \u043e\u0436\u0438\u0434\u0430\u0435\u043c\u044b\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 (.+?)( \u043d\u0435|) \u0440\u0430\u0432\u0435\u043d \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u043c\u0443 (.+?)$")
    public void equalsObject(Object expect, boolean not, Object actual) {
        if (not) {
            this.verifier.notEquals(MSG, expect, actual, new String[0]);
        } else {
            this.verifier.equals(MSG, expect, actual, new String[0]);
        }
    }

    @Given(value="^\u043f\u0440\u043e\u0432\u0435\u0440\u0435\u043d\u043e, \u0447\u0442\u043e \u043e\u0436\u0438\u0434\u0430\u0435\u043c\u0430\u044f \u0441\u0442\u0440\u043e\u043a\u0430 '(.+?)'( \u043d\u0435|) (\u0440\u0430\u0432\u043d\u0430|\u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u0432) \u0430\u043a\u0442\u0430\u0443\u043b\u044c\u043d\u043e\u0439 '(.+?)'( \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044f \u043d\u043e\u0440\u043c\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044e|)$")
    public void equalsString(String expect, boolean not, String type, String actual, boolean normalize) {
        if (normalize) {
            expect = Strings.normalize((String)expect);
            actual = Strings.normalize((String)actual);
        }
        switch (type) {
            case "\u0440\u0430\u0432\u043d\u0430": {
                if (not) {
                    this.verifier.notEquals(MSG, expect, actual, new String[0]);
                    break;
                }
                this.verifier.equals(MSG, expect, actual, new String[0]);
                break;
            }
            case "\u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u0432": {
                if (not) {
                    this.verifier.notContains(MSG, expect, actual, new String[0]);
                    break;
                }
                this.verifier.contains(MSG, expect, actual, new String[0]);
                break;
            }
            default: {
                this.operationTypeError(type);
            }
        }
    }

    @Given(value="^\u043f\u0440\u043e\u0432\u0435\u0440\u0435\u043d\u043e, \u0447\u0442\u043e \u043e\u0436\u0438\u0434\u0430\u0435\u043c\u043e\u0435 \u0447\u0438\u0441\u043b\u043e (.+?)( \u043d\u0435|) (\u0440\u0430\u0432\u043d\u043e|\u0431\u043e\u043b\u044c\u0448\u0435|\u043c\u0435\u043d\u044c\u0448\u0435|\u0431\u043e\u043b\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e|\u043c\u0435\u043d\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e) \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d(?:\u043e\u043c\u0443|\u043e\u0433\u043e) (.+?)$")
    public void equalsNumber(long expect, boolean not, String type, long actual) {
        switch (type) {
            case "\u0440\u0430\u0432\u043d\u043e": {
                if (not) {
                    this.verifier.notEquals(MSG, (Object)expect, (Object)actual, new String[0]);
                    break;
                }
                this.verifier.equals(MSG, (Object)expect, (Object)actual, new String[0]);
                break;
            }
            case "\u0431\u043e\u043b\u044c\u0448\u0435": {
                if (not) {
                    this.verifier.checkFalse(MSG + type, expect > actual, new String[0]);
                    break;
                }
                this.verifier.checkTrue(MSG + type, expect > actual, new String[0]);
                break;
            }
            case "\u043c\u0435\u043d\u044c\u0448\u0435": {
                if (not) {
                    this.verifier.checkFalse(MSG + type, expect < actual, new String[0]);
                    break;
                }
                this.verifier.checkTrue(MSG + type, expect < actual, new String[0]);
                break;
            }
            case "\u0431\u043e\u043b\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e": {
                if (not) {
                    this.verifier.checkFalse(MSG + type, expect >= actual, new String[0]);
                    break;
                }
                this.verifier.checkTrue(MSG + type, expect >= actual, new String[0]);
                break;
            }
            case "\u043c\u0435\u043d\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e": {
                if (not) {
                    this.verifier.checkFalse(MSG + type, expect <= actual, new String[0]);
                    break;
                }
                this.verifier.checkTrue(MSG + type, expect <= actual, new String[0]);
                break;
            }
            default: {
                this.operationTypeError(type);
            }
        }
    }

    @Given(value="^\u043f\u0440\u043e\u0432\u0435\u0440\u0435\u043d\u043e, \u0447\u0442\u043e \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (.+?) (\u0438\u0441\u0442\u0438\u043d\u0430|\u043b\u043e\u0436\u044c|null|\u043d\u0435 null)$")
    public void isTrue(Object object, String type) {
        switch (type) {
            case "\u0438\u0441\u0442\u0438\u043d\u0430": {
                if (object instanceof Boolean) {
                    this.verifier.checkTrue(MSG, ((Boolean)object).booleanValue(), new String[0]);
                    break;
                }
                this.verifier.notNull(MSG, object, new String[0]);
                break;
            }
            case "\u043b\u043e\u0436\u044c": {
                if (object instanceof Boolean) {
                    this.verifier.checkFalse(MSG, ((Boolean)object).booleanValue(), new String[0]);
                    break;
                }
                this.verifier.checkNull(MSG, object, new String[0]);
                break;
            }
            case "null": {
                this.verifier.checkNull(MSG, object, new String[0]);
                break;
            }
            case "\u043d\u0435 null": {
                this.verifier.notNull(MSG, object, new String[0]);
                break;
            }
            default: {
                this.operationTypeError(type);
            }
        }
    }

    @Given(value="^\u043f\u0440\u043e\u0432\u0435\u0440\u0435\u043d\u043e, \u0447\u0442\u043e \u043e\u0436\u0438\u0434\u0430\u0435\u043c\u044b\u0439 \u0441\u043f\u0438\u0441\u043e\u043a \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 '(.+?)' (\u0440\u0430\u0432\u0435\u043d \u0441\u043f\u0438\u0441\u043a\u0443|\u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u0432 \u0441\u043f\u0438\u0441\u043a\u0435) '(.+?)'( \u0441 \u0443\u0447\u0435\u0442\u043e\u043c \u043f\u043e\u0437\u0438\u0446\u0438\u0438|)$")
    public void equalsList(List<String> expect, String type, List<String> actual, boolean strict) {
        switch (type) {
            case "\u0440\u0430\u0432\u0435\u043d \u0441\u043f\u0438\u0441\u043a\u0443": {
                if (strict) {
                    this.verifier.listEquals(MSG, expect, actual, Collators.equals(), null);
                    break;
                }
                expect.sort(Comparator.naturalOrder());
                this.verifier.listEquals(MSG, expect, actual, Collators.equals(), Comparator.naturalOrder());
                break;
            }
            case "\u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u0432 \u0441\u043f\u0438\u0441\u043a\u0435": {
                if (strict) {
                    this.verifier.listStrictContains(MSG, expect, actual, Collators.liteNormalizeContains(), null);
                    break;
                }
                this.verifier.listContains(MSG, expect, actual, Collators.liteNormalizeContains());
                break;
            }
            default: {
                this.operationTypeError(type);
            }
        }
    }
}

