/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.cucumber.plugin;

import java.util.Deque;
import ru.mk.pump.cucumber.plugin.CucumberListener;
import ru.mk.pump.cucumber.plugin.CucumberMonitor;
import ru.mk.pump.web.browsers.Browser;
import ru.mk.pump.web.browsers.Browsers;
import ru.mk.pump.web.browsers.configuration.BrowserConfig;

public class BrowserManager
implements CucumberListener {
    private final boolean oneBrowserAllFeature;
    private final Browsers browsers;
    private final BrowserConfig browserConfig;

    BrowserManager(Browsers browsers, BrowserConfig browserConfig, boolean oneBrowserAllFeature) {
        this.browsers = browsers;
        this.browserConfig = browserConfig;
        this.oneBrowserAllFeature = oneBrowserAllFeature;
    }

    @Override
    public void onStartTest(CucumberMonitor monitor) {
    }

    @Override
    public void onStartFeature(CucumberMonitor monitor) {
        if (this.oneBrowserAllFeature) {
            if (!this.browsers.has()) {
                this.browsers.newBrowser(this.browserConfig);
            } else if (this.browsers.get().isClosed()) {
                Deque browserDeque = this.browsers.getStartedBrowsers();
                if (browserDeque.isEmpty()) {
                    this.browsers.newBrowser(this.browserConfig);
                } else {
                    this.browsers.setBrowser((Browser)browserDeque.getLast());
                }
            }
        } else {
            this.browsers.closeCurrentThread();
            this.browsers.newBrowser(this.browserConfig);
        }
        this.browsers.get().start();
    }

    @Override
    public void onStartScenario(CucumberMonitor monitor) {
    }

    @Override
    public void onFinishTest(CucumberMonitor monitor) {
        this.browsers.close();
    }

    @Override
    public void onFinishFeature(CucumberMonitor monitor) {
        if (!this.oneBrowserAllFeature) {
            this.browsers.closeCurrentThread();
        }
    }

    @Override
    public void onFinishScenario(CucumberMonitor monitor) {
    }
}

