/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.cucumber.plugin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.cucumber.CucumberCore;
import ru.mk.pump.cucumber.plugin.CucumberListener;
import ru.mk.pump.cucumber.plugin.Feature;
import ru.mk.pump.cucumber.plugin.Listeners;

public class CucumberMonitor {
    private Set<CucumberListener> listeners = Sets.newHashSet();
    private Set<CucumberListener> runtimeListeners = Sets.newHashSet();
    private boolean started;
    private boolean finished;
    private List<Feature> featureList = Lists.newArrayList();

    public static CucumberMonitor newInactive() {
        return new CucumberMonitor();
    }

    public void checkPlugin() {
        if (!this.isStarted() && !this.isFinished() && CucumberCore.instance().getConfig().isLoadPumpPlugin()) {
            throw new IllegalStateException(Strings.space((String[])new String[]{"You must enable ru.mk.pump.cucumber.plugin.PumpCucumberPlugin in cucumber options. ", "In @CucumberOptions add parameter 'plugin = {\"ru.mk.pump.cucumber.plugin.PumpCucumberPlugin\"}'. ", "Or in java args add parameter '--plugin ru.mk.pump.cucumber.plugin.PumpCucumberPlugin'"}));
        }
    }

    public CucumberMonitor addRuntimeListeners(Set<CucumberListener> cucumberListeners) {
        this.runtimeListeners.addAll(cucumberListeners);
        return this;
    }

    public CucumberMonitor addRuntimeListener(CucumberListener cucumberListener) {
        this.runtimeListeners.add(cucumberListener);
        return this;
    }

    public Optional<Feature> getLastFeature() {
        if (this.getAllFeatures().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Feature)Iterables.getLast(this.getAllFeatures()));
    }

    static CucumberMonitor newDefault() {
        return new CucumberMonitor().addListeners(Listeners.defaultListeners(CucumberCore.instance().getConfig()));
    }

    Set<CucumberListener> getRuntimeListeners() {
        return ImmutableSet.copyOf(this.runtimeListeners);
    }

    Set<CucumberListener> getListeners() {
        return ImmutableSet.copyOf(this.listeners);
    }

    CucumberMonitor addListeners(Set<CucumberListener> cucumberListeners) {
        this.listeners.addAll(cucumberListeners);
        return this;
    }

    CucumberMonitor addListener(CucumberListener cucumberListener) {
        this.listeners.add(cucumberListener);
        return this;
    }

    List<Feature> getAllFeatures() {
        return ImmutableList.copyOf(this.featureList);
    }

    void started() {
        this.started = true;
    }

    void finished() {
        this.started = false;
        this.finished = true;
    }

    void addFeature(Feature feature) {
        this.featureList.add(feature);
    }

    void updateFeature(Consumer<Feature> updater) {
        this.getLastFeature().ifPresent(updater);
    }

    private CucumberMonitor() {
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isFinished() {
        return this.finished;
    }
}

