/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.cucumber.plugin;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import cucumber.api.Result;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import ru.mk.pump.commons.exception.PumpMessage;
import ru.mk.pump.commons.interfaces.PrettyPrinter;
import ru.mk.pump.commons.interfaces.StrictInfo;
import ru.mk.pump.cucumber.plugin.Scenario;

public class Feature
implements StrictInfo,
PrettyPrinter {
    private final String url;
    private final UUID uuid;
    private final String source;
    private boolean finished;
    private Result.Type status;
    private Scenario nonPassedScenario;
    private Scenario activeScenario;
    private List<Scenario> executedScenarios = Lists.newArrayList();

    Feature(String url, String source) {
        this.source = source;
        this.uuid = UUID.randomUUID();
        this.url = url;
        this.status = Result.Type.UNDEFINED;
    }

    public boolean isOk() {
        return this.nonPassedScenario == null;
    }

    public Optional<Scenario> getLastExecutedScenario() {
        if (this.executedScenarios.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable((Scenario)Iterables.getLast(this.executedScenarios));
    }

    public Optional<Scenario> getActiveScenario() {
        return Optional.ofNullable(this.activeScenario);
    }

    public List<Scenario> nonPassedScenarios() {
        return this.executedScenarios.stream().filter(s -> s.getStatus() != Result.Type.PASSED).collect(Collectors.toList());
    }

    public String toPrettyString() {
        return PumpMessage.of((StrictInfo)this).toPrettyString();
    }

    public Map<String, String> getInfo() {
        return StrictInfo.infoBuilder((String)"feature").put("uuid", this.uuid.toString()).put("url", this.url).put("source", this.source).put("status", this.status.name()).put("scenarios", Integer.toString(this.executedScenarios.size())).build();
    }

    void finish() {
        this.finished = true;
    }

    Feature startScenario(Scenario activeScenario) {
        this.activeScenario = activeScenario;
        return this;
    }

    Feature releaseScenario(Result result) {
        this.executedScenarios.add(this.updateStatus(this.activeScenario, result));
        this.activeScenario = null;
        return this;
    }

    private Scenario updateStatus(Scenario scenario, Result result) {
        if (result.getStatus() != Result.Type.PASSED && result.getStatus() != Result.Type.SKIPPED) {
            this.nonPassedScenario = scenario;
        }
        scenario.setResult(result);
        this.status = result.getStatus();
        return scenario;
    }

    public String toString() {
        return "Feature(url=" + this.getUrl() + ", uuid=" + this.getUuid() + ", source=" + this.getSource() + ", finished=" + this.isFinished() + ", status=" + this.getStatus() + ", nonPassedScenario=" + this.getNonPassedScenario() + ", activeScenario=" + this.getActiveScenario() + ", executedScenarios=" + this.getExecutedScenarios() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Feature)) {
            return false;
        }
        Feature other = (Feature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        return !(this$source == null ? other$source != null : !this$source.equals(other$source));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Feature;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        return result;
    }

    public String getUrl() {
        return this.url;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Result.Type getStatus() {
        return this.status;
    }

    public Scenario getNonPassedScenario() {
        return this.nonPassedScenario;
    }

    public List<Scenario> getExecutedScenarios() {
        return this.executedScenarios;
    }
}

