/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.cucumber.plugin;

import io.qameta.allure.util.PropertiesUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.config.ConfigurationsLoader;
import ru.mk.pump.commons.reporter.Reporter;
import ru.mk.pump.commons.utils.FileUtils;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.cucumber.CucumberCore;
import ru.mk.pump.cucumber.plugin.CucumberListener;
import ru.mk.pump.cucumber.plugin.CucumberMonitor;
import ru.mk.pump.web.configuration.ConfigurationHolder;

public class InformationManager
implements CucumberListener {
    private static final Logger log = LoggerFactory.getLogger(InformationManager.class);
    private final Reporter reporter;
    private CucumberCore cucumberCore;

    InformationManager(CucumberCore cucumberCore) {
        this.cucumberCore = cucumberCore;
        this.reporter = cucumberCore.getReporter();
    }

    @Override
    public void onStartTest(CucumberMonitor monitor) {
        if (ConfigurationHolder.instance().getConfigurationHelper().getLoader().isPresent()) {
            this.reporter.info("Framework configuration", ((ConfigurationsLoader)ConfigurationHolder.instance().getConfigurationHelper().getLoader().get()).getHistory().toPrettyString());
        } else {
            this.reporter.info("Pump configuration", Strings.toString((Object)ConfigurationHolder.instance().getConfigurationHelper().getActualConfig()));
        }
        if (this.cucumberCore.getConfigHelper().getLoader().isPresent()) {
            this.reporter.info("Cucumber configuration", ((ConfigurationsLoader)this.cucumberCore.getConfigHelper().getLoader().get()).getHistory().toPrettyString());
        } else {
            this.reporter.info("Cucumber configuration", Strings.toString((Object)this.cucumberCore.getConfigHelper().getActualConfig()));
        }
        this.reporter.info("Stand configuration", "not implemented yet");
    }

    @Override
    public void onStartFeature(CucumberMonitor monitor) {
        monitor.getLastFeature().ifPresent(feature -> this.reporter.info("Feature started", feature.toPrettyString(), this.reporter.attachments().dummy()));
    }

    @Override
    public void onStartScenario(CucumberMonitor monitor) {
    }

    @Override
    public void onFinishTest(CucumberMonitor monitor) {
        this.reporter.info("Test Variables", this.cucumberCore.getTestVariables().toPrettyString());
        this.copyStandConfig();
    }

    @Override
    public void onFinishFeature(CucumberMonitor monitor) {
    }

    @Override
    public void onFinishScenario(CucumberMonitor monitor) {
    }

    private void copyStandConfig() {
        try {
            if (this.cucumberCore.getStandConfig() != null) {
                Properties properties = PropertiesUtils.loadAllureProperties();
                Path resultDir = Paths.get(properties.getProperty("allure.results.directory", "allure-results"), new String[0]);
                Path source = this.cucumberCore.getStandConfig().getPropertiesFile();
                FileUtils.copy((Path)source, (Path)resultDir.resolve("environment.properties"));
            }
        }
        catch (Exception ex) {
            log.error("Cannot copy environment.properties", (Throwable)ex);
        }
        log.warn("Environment properties (Stand.class) in CucumberCore.class was not defined");
    }
}

