/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.cucumber.plugin;

import cucumber.api.Plugin;
import cucumber.api.event.ConcurrentEventListener;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestRunStarted;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import io.qameta.allure.cucumber3jvm.AllureCucumber3Jvm;
import ru.mk.pump.commons.listener.AbstractNotifier;
import ru.mk.pump.commons.reporter.Reporter;
import ru.mk.pump.cucumber.CucumberCore;
import ru.mk.pump.cucumber.plugin.CucumberListener;
import ru.mk.pump.cucumber.plugin.CucumberMonitor;
import ru.mk.pump.cucumber.plugin.Feature;
import ru.mk.pump.cucumber.plugin.Scenario;

public class PumpCucumberPlugin
extends AbstractNotifier<CucumberMonitor, CucumberListener.TestEvent, CucumberListener>
implements ConcurrentEventListener,
Plugin {
    private final AllureCucumber3Jvm allureCucumber2Jvm;
    private final Reporter reporter;
    private final CucumberMonitor monitor;
    private final EventHandler<TestRunStarted> testStartedHandler = this::testStarted;
    private final EventHandler<TestCaseStarted> caseStartedHandler = this::caseStarted;
    private final EventHandler<TestCaseFinished> caseFinishedHandler = this::caseFinished;
    private final EventHandler<TestStepStarted> stepStartedHandler = this::stepStarted;
    private final EventHandler<TestStepFinished> stepFinishedHandler = this::stepFinished;
    private final EventHandler<TestRunFinished> testFinishedHandler = this::testFinished;

    public PumpCucumberPlugin() {
        this.reporter = CucumberCore.instance().getReporter();
        this.monitor = CucumberMonitor.newDefault();
        this.allureCucumber2Jvm = new AllureCucumber3Jvm();
        CucumberCore.instance().setMonitor(this.monitor);
        this.monitor.started();
        this.addListeners(this.monitor.getListeners());
    }

    public void setEventPublisher(EventPublisher publisher) {
        if (CucumberCore.instance().getConfig().isLoadPumpPlugin()) {
            publisher.registerHandlerFor(TestRunStarted.class, this.testStartedHandler);
            publisher.registerHandlerFor(TestCaseFinished.class, this.caseFinishedHandler);
            publisher.registerHandlerFor(TestRunFinished.class, this.testFinishedHandler);
            this.allureCucumber2Jvm.setEventPublisher(publisher);
            publisher.registerHandlerFor(TestCaseStarted.class, this.caseStartedHandler);
            publisher.registerHandlerFor(TestStepStarted.class, this.stepStartedHandler);
            publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        }
    }

    private void testStarted(TestRunStarted event) {
        this.reporter.testStart("EXECUTION INFORMATION", "General execution steam of the test and all the service steps not included in the main report");
        this.notify(this.event(this.monitor, CucumberListener.TestEvent.START_TEST));
    }

    private void testFinished(TestRunFinished event) {
        if (this.monitor.getLastFeature().isPresent()) {
            this.monitor.getLastFeature().get().finish();
            this.notify(this.event(this.monitor, CucumberListener.TestEvent.FINISH_FEATURE));
        }
        this.notify(this.event(this.monitor, CucumberListener.TestEvent.FINISH_TEST));
        this.monitor.finished();
        this.reporter.testStop();
    }

    private void caseStarted(TestCaseStarted event) {
        if (this.monitor.getLastFeature().isPresent() && !this.monitor.getLastFeature().get().getUrl().equals(event.testCase.getUri())) {
            this.monitor.getLastFeature().get().finish();
            this.notify(this.event(this.monitor, CucumberListener.TestEvent.FINISH_FEATURE));
            this.monitor.addFeature(new Feature(event.testCase.getUri(), event.testCase.getScenarioDesignation()));
            this.notify(this.event(this.monitor, CucumberListener.TestEvent.START_FEATURE));
        } else if (!this.monitor.getLastFeature().isPresent()) {
            this.monitor.addFeature(new Feature(event.testCase.getUri(), event.testCase.getScenarioDesignation()));
            this.notify(this.event(this.monitor, CucumberListener.TestEvent.START_FEATURE));
        }
        this.monitor.updateFeature(feature -> feature.startScenario(new Scenario(event.testCase)));
        this.notify(this.event(this.monitor, CucumberListener.TestEvent.START_SCENARIO));
    }

    private void caseFinished(TestCaseFinished event) {
        this.monitor.updateFeature(feature -> feature.releaseScenario(event.result));
        this.notify(this.event(this.monitor, CucumberListener.TestEvent.FINISH_SCENARIO));
    }

    private void stepStarted(TestStepStarted event) {
    }

    private void stepFinished(TestStepFinished event) {
    }
}

