/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.cucumber.plugin;

import cucumber.api.Result;
import cucumber.api.TestCase;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import ru.mk.pump.commons.exception.PumpMessage;
import ru.mk.pump.commons.interfaces.PrettyPrinter;
import ru.mk.pump.commons.interfaces.StrictInfo;

public class Scenario
implements PrettyPrinter,
StrictInfo {
    private final UUID uuid = UUID.randomUUID();
    private final TestCase testCase;
    private Result result;

    Scenario(TestCase testCase) {
        this.testCase = testCase;
        this.result = null;
    }

    public Optional<Result> getResult() {
        return Optional.ofNullable(this.result);
    }

    void setResult(Result result) {
        this.result = result;
    }

    public Result.Type getStatus() {
        if (this.result == null) {
            return Result.Type.UNDEFINED;
        }
        return this.result.getStatus();
    }

    public String toPrettyString() {
        return PumpMessage.of((StrictInfo)this).toPrettyString();
    }

    public Map<String, String> getInfo() {
        StrictInfo.StringMapBuilder res = StrictInfo.infoBuilder((String)"scenario").put("uuid", this.uuid.toString()).put("name", this.testCase.getName()).put("designation", this.testCase.getScenarioDesignation());
        if (this.result != null) {
            res.put("result", this.result.getStatus().name());
        }
        return res.build();
    }

    public String toString() {
        return "Scenario(uuid=" + this.getUuid() + ", testCase=" + this.getTestCase() + ", result=" + this.getResult() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Scenario)) {
            return false;
        }
        Scenario other = (Scenario)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        return !(this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Scenario;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        return result;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public TestCase getTestCase() {
        return this.testCase;
    }
}

