/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.browsers;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Observer;
import lombok.NonNull;
import org.openqa.selenium.WebDriver;
import ru.mk.pump.commons.activity.AbstractActivity;
import ru.mk.pump.commons.activity.Activity;
import ru.mk.pump.commons.activity.ActivityListener;
import ru.mk.pump.commons.activity.NamedEvent;
import ru.mk.pump.commons.exception.PumpMessage;
import ru.mk.pump.commons.interfaces.StrictInfo;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.web.browsers.Browser;
import ru.mk.pump.web.browsers.BrowserActions;
import ru.mk.pump.web.browsers.DownloadManager;
import ru.mk.pump.web.browsers.DriverBuilder;
import ru.mk.pump.web.browsers.LogManager;
import ru.mk.pump.web.browsers.WindowManager;
import ru.mk.pump.web.browsers.configuration.BrowserConfig;
import ru.mk.pump.web.browsers.configuration.BrowserType;
import ru.mk.pump.web.exceptions.BrowserException;
import ru.mk.pump.web.utils.WebReporter;

public abstract class AbstractBrowser
extends AbstractActivity
implements Browser {
    private final DriverBuilder builder;
    private final BrowserConfig config;
    private final String id;
    private final WindowManager windows;
    private final DownloadManager downloads;
    private final BrowserActions actions;
    private final LogManager logs;
    private WebDriver driver = null;

    public AbstractBrowser(@NonNull DriverBuilder builder, @NonNull String uuid) {
        super(uuid);
        if (builder == null) {
            throw new NullPointerException("builder is marked @NonNull but is null");
        }
        if (uuid == null) {
            throw new NullPointerException("uuid is marked @NonNull but is null");
        }
        this.builder = builder;
        this.config = builder.getConfig();
        this.id = this.config.getType().name() + "_" + uuid;
        this.downloads = new DownloadManager(this.getConfig());
        this.actions = new BrowserActions(this::getDriver);
        this.logs = new LogManager();
        this.windows = new WindowManager(this);
        this.addObserver(this.getDefaultListener());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Browser start() {
        if (this.isClosed()) {
            throw new BrowserException("Cannot start browser. Browser has been already closed and this instance of Browser cannot start", this);
        }
        if (!this.isStarted()) {
            this.driver = this.builder.createAndStartDriver();
            if (this.driver == null) {
                throw new BrowserException("Cannot start browser. Incorrect driver builder", this);
            }
            this.activate();
        }
        return this;
    }

    @Override
    @NonNull
    public WebDriver getDriver() {
        if (this.driver == null) {
            throw new BrowserException("Cannot get WebDriver - browser was not started or closed", this);
        }
        return this.driver;
    }

    @Override
    public BrowserConfig getConfig() {
        return this.builder.getConfig();
    }

    @Override
    public boolean isStarted() {
        return this.isActive();
    }

    @Override
    public Browser open(String url) {
        this.getDriver().get(url);
        return this;
    }

    @Override
    public WebDriver.Navigation navigate() {
        return this.getDriver().navigate();
    }

    @Override
    public Browser refresh() {
        this.getDriver().navigate().refresh();
        return this;
    }

    @Override
    public WindowManager windows() {
        return this.windows;
    }

    @Override
    public DownloadManager downloads() {
        return this.downloads;
    }

    @Override
    public LogManager logs() {
        return this.logs;
    }

    @Override
    public BrowserActions actions() {
        return this.actions;
    }

    public Activity disable() {
        this.close();
        return this;
    }

    @Override
    public void close() {
        if (this.driver != null && !this.isClosed()) {
            if (this.isStarted()) {
                this.forkCloseByBrowserType();
                this.driver = null;
            } else {
                this.driver = null;
            }
        }
        super.close();
    }

    public Map<String, String> getInfo() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("id", this.id);
        result.put("builder", this.builder.getClass().getSimpleName());
        result.put("config", this.config.toString());
        return result;
    }

    private void forkCloseByBrowserType() {
        if (this.getConfig().getType() == BrowserType.PHANTOMJS) {
            this.driver.close();
            this.driver.quit();
        } else {
            this.driver.quit();
        }
    }

    protected Observer getDefaultListener() {
        return new ActivityListener(){

            public void onClose(NamedEvent namedEvent, Activity activity) {
                this.report(namedEvent, activity);
            }

            public void onActivate(NamedEvent namedEvent, Activity activity) {
                this.report(namedEvent, activity);
            }

            public void onDisable(NamedEvent namedEvent, Activity activity) {
                this.report(namedEvent, activity);
            }

            private void report(NamedEvent namedEvent, Activity activity) {
                PumpMessage msg = new PumpMessage(Strings.toString((Object)namedEvent)).addExtraInfo((StrictInfo)((AbstractBrowser)activity));
                WebReporter.getReporter().info("Browser has been " + namedEvent.getName(), msg.toPrettyString());
            }
        };
    }

    public String toString() {
        return "AbstractBrowser(super=" + super.toString() + ", config=" + this.getConfig() + ", id=" + this.getId() + ")";
    }
}

