/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.browsers;

import java.util.Observer;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.activity.AbstractActivity;
import ru.mk.pump.commons.activity.Activity;
import ru.mk.pump.commons.activity.ActivityListener;
import ru.mk.pump.commons.activity.NamedEvent;
import ru.mk.pump.commons.exception.PumpMessage;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.web.utils.WebReporter;

public final class Window
extends AbstractActivity {
    private static final Logger log = LoggerFactory.getLogger(Window.class);
    private final WebDriver driver;

    private Window(Observer observer, String uuid, WebDriver driver) {
        super(observer, uuid);
        this.driver = driver;
        this.addObserver(this.getDefaultListener());
    }

    public static Window of(Observer observer, WebDriver driver, String windowDriverUuid) {
        return new Window(observer, windowDriverUuid, driver);
    }

    public Activity activate() {
        if (this.getUUID().equals(this.driver.getWindowHandle())) {
            this.driver.switchTo().window(this.getUUID());
        }
        return super.activate();
    }

    public void close() {
        this.driver.switchTo().window(this.getUUID());
        this.driver.close();
        super.close();
    }

    private Observer getDefaultListener() {
        return new ActivityListener(){

            public void onClose(NamedEvent namedEvent, Activity activity) {
                this.report(namedEvent, activity);
            }

            public void onActivate(NamedEvent namedEvent, Activity activity) {
                this.report(namedEvent, activity);
            }

            public void onDisable(NamedEvent namedEvent, Activity activity) {
                this.report(namedEvent, activity);
            }

            private void report(NamedEvent namedEvent, Activity activity) {
                PumpMessage msg = new PumpMessage(Strings.toString((Object)namedEvent)).withDesc(activity.toString());
                WebReporter.getReporter().info("Window has been " + namedEvent.getName(), msg.toPrettyString());
            }
        };
    }

    public String toString() {
        return "Window(super=" + super.toString() + ", driver=" + this.driver + ")";
    }
}

