/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.browsers.builders;

import org.apache.commons.lang3.SystemUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import ru.mk.pump.commons.utils.ProjectResources;
import ru.mk.pump.web.browsers.builders.AbstractDriverBuilder;
import ru.mk.pump.web.browsers.builders.BuilderHelper;
import ru.mk.pump.web.browsers.configuration.BrowserConfig;

public class GhostDriverBuilder
extends AbstractDriverBuilder<DesiredCapabilities> {
    public GhostDriverBuilder(BrowserConfig browserConfig) {
        super(browserConfig, new BuilderHelper(browserConfig));
    }

    @Override
    protected DesiredCapabilities getSpecialCapabilities() {
        return this.getCapabilities();
    }

    @Override
    protected WebDriver createLocalDriver(DesiredCapabilities allCapabilities) {
        return new PhantomJSDriver((Capabilities)allCapabilities);
    }

    private DesiredCapabilities getCapabilities() {
        DesiredCapabilities options = new DesiredCapabilities();
        if (SystemUtils.IS_OS_WINDOWS) {
            options.setCapability("phantomjs.binary.path", ProjectResources.findResource((String)"phantomjs.exe").toString());
        }
        return options;
    }
}

