/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.browsers.configuration;

import org.openqa.selenium.remote.DesiredCapabilities;
import ru.mk.pump.commons.config.Property;
import ru.mk.pump.commons.helpers.Parameters;
import ru.mk.pump.web.browsers.configuration.BrowserType;
import ru.mk.pump.web.browsers.configuration.Size;

public class BrowserConfig {
    @Property(value="remote", defaultValue="false")
    private boolean remoteDriver;
    @Property(value="remote.url", required=false)
    private String remoteDriverUrl;
    @Property(value="download.dir", defaultValue="auto_downloads")
    private String downloadDirPath = "auto_downloads";
    @Property(value="size", required=false)
    private Size sizeOrDevice = Size.of(true);
    @Property(value="type")
    private BrowserType type;
    @Property(value="bin.path", required=false)
    private String browserBinPath;
    @Property(value="driver.path", required=false)
    private String webDriverPath;
    @Property(value="version", required=false)
    private String version;
    @Property(value="debug", defaultValue="false")
    private boolean debug = false;
    @Property(value="vnc", defaultValue="false")
    private boolean selenoidVnc = false;
    @Property(value="capabilities.file", required=false)
    private String capabilitiesFile;
    private Parameters extraParams = Parameters.of();
    private DesiredCapabilities capabilities;
    @Property(value="appium.platform.name", required=false)
    private String appiumPlatformName;
    @Property(value="appium.platform.version", required=false)
    private String appiumPlatformVersion;
    @Property(value="appium.device.name", required=false)
    private String appiumDeviceName;
    @Property(value="appium.app.path", required=false)
    private String appiumApp;
    @Property(value="appium.app.package", required=false)
    private String appiumAppPackage;
    @Property(value="appium.app.activity", required=false)
    private String appiumAppActivity;

    public static BrowserConfig of(BrowserType type) {
        return BrowserConfig.of(null, type);
    }

    public static BrowserConfig of(Size sizeOrDevice, BrowserType type) {
        BrowserConfig res = new BrowserConfig();
        res.setType(type);
        res.setSizeOrDevice(sizeOrDevice);
        return res;
    }

    public boolean isRemoteDriver() {
        return this.remoteDriver;
    }

    public String getRemoteDriverUrl() {
        return this.remoteDriverUrl;
    }

    public String getDownloadDirPath() {
        return this.downloadDirPath;
    }

    public Size getSizeOrDevice() {
        return this.sizeOrDevice;
    }

    public BrowserType getType() {
        return this.type;
    }

    public String getBrowserBinPath() {
        return this.browserBinPath;
    }

    public String getWebDriverPath() {
        return this.webDriverPath;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isSelenoidVnc() {
        return this.selenoidVnc;
    }

    public String getCapabilitiesFile() {
        return this.capabilitiesFile;
    }

    public Parameters getExtraParams() {
        return this.extraParams;
    }

    public DesiredCapabilities getCapabilities() {
        return this.capabilities;
    }

    public String getAppiumPlatformName() {
        return this.appiumPlatformName;
    }

    public String getAppiumPlatformVersion() {
        return this.appiumPlatformVersion;
    }

    public String getAppiumDeviceName() {
        return this.appiumDeviceName;
    }

    public String getAppiumApp() {
        return this.appiumApp;
    }

    public String getAppiumAppPackage() {
        return this.appiumAppPackage;
    }

    public String getAppiumAppActivity() {
        return this.appiumAppActivity;
    }

    public void setRemoteDriver(boolean remoteDriver) {
        this.remoteDriver = remoteDriver;
    }

    public void setRemoteDriverUrl(String remoteDriverUrl) {
        this.remoteDriverUrl = remoteDriverUrl;
    }

    public void setDownloadDirPath(String downloadDirPath) {
        this.downloadDirPath = downloadDirPath;
    }

    public void setSizeOrDevice(Size sizeOrDevice) {
        this.sizeOrDevice = sizeOrDevice;
    }

    public void setType(BrowserType type) {
        this.type = type;
    }

    public void setBrowserBinPath(String browserBinPath) {
        this.browserBinPath = browserBinPath;
    }

    public void setWebDriverPath(String webDriverPath) {
        this.webDriverPath = webDriverPath;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setSelenoidVnc(boolean selenoidVnc) {
        this.selenoidVnc = selenoidVnc;
    }

    public void setCapabilitiesFile(String capabilitiesFile) {
        this.capabilitiesFile = capabilitiesFile;
    }

    public void setExtraParams(Parameters extraParams) {
        this.extraParams = extraParams;
    }

    public void setCapabilities(DesiredCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    public void setAppiumPlatformName(String appiumPlatformName) {
        this.appiumPlatformName = appiumPlatformName;
    }

    public void setAppiumPlatformVersion(String appiumPlatformVersion) {
        this.appiumPlatformVersion = appiumPlatformVersion;
    }

    public void setAppiumDeviceName(String appiumDeviceName) {
        this.appiumDeviceName = appiumDeviceName;
    }

    public void setAppiumApp(String appiumApp) {
        this.appiumApp = appiumApp;
    }

    public void setAppiumAppPackage(String appiumAppPackage) {
        this.appiumAppPackage = appiumAppPackage;
    }

    public void setAppiumAppActivity(String appiumAppActivity) {
        this.appiumAppActivity = appiumAppActivity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrowserConfig)) {
            return false;
        }
        BrowserConfig other = (BrowserConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRemoteDriver() != other.isRemoteDriver()) {
            return false;
        }
        String this$remoteDriverUrl = this.getRemoteDriverUrl();
        String other$remoteDriverUrl = other.getRemoteDriverUrl();
        if (this$remoteDriverUrl == null ? other$remoteDriverUrl != null : !this$remoteDriverUrl.equals(other$remoteDriverUrl)) {
            return false;
        }
        String this$downloadDirPath = this.getDownloadDirPath();
        String other$downloadDirPath = other.getDownloadDirPath();
        if (this$downloadDirPath == null ? other$downloadDirPath != null : !this$downloadDirPath.equals(other$downloadDirPath)) {
            return false;
        }
        Size this$sizeOrDevice = this.getSizeOrDevice();
        Size other$sizeOrDevice = other.getSizeOrDevice();
        if (this$sizeOrDevice == null ? other$sizeOrDevice != null : !this$sizeOrDevice.equals(other$sizeOrDevice)) {
            return false;
        }
        BrowserType this$type = this.getType();
        BrowserType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$browserBinPath = this.getBrowserBinPath();
        String other$browserBinPath = other.getBrowserBinPath();
        if (this$browserBinPath == null ? other$browserBinPath != null : !this$browserBinPath.equals(other$browserBinPath)) {
            return false;
        }
        String this$webDriverPath = this.getWebDriverPath();
        String other$webDriverPath = other.getWebDriverPath();
        if (this$webDriverPath == null ? other$webDriverPath != null : !this$webDriverPath.equals(other$webDriverPath)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        if (this.isSelenoidVnc() != other.isSelenoidVnc()) {
            return false;
        }
        String this$capabilitiesFile = this.getCapabilitiesFile();
        String other$capabilitiesFile = other.getCapabilitiesFile();
        if (this$capabilitiesFile == null ? other$capabilitiesFile != null : !this$capabilitiesFile.equals(other$capabilitiesFile)) {
            return false;
        }
        Parameters this$extraParams = this.getExtraParams();
        Parameters other$extraParams = other.getExtraParams();
        if (this$extraParams == null ? other$extraParams != null : !this$extraParams.equals(other$extraParams)) {
            return false;
        }
        DesiredCapabilities this$capabilities = this.getCapabilities();
        DesiredCapabilities other$capabilities = other.getCapabilities();
        if (this$capabilities == null ? other$capabilities != null : !this$capabilities.equals(other$capabilities)) {
            return false;
        }
        String this$appiumPlatformName = this.getAppiumPlatformName();
        String other$appiumPlatformName = other.getAppiumPlatformName();
        if (this$appiumPlatformName == null ? other$appiumPlatformName != null : !this$appiumPlatformName.equals(other$appiumPlatformName)) {
            return false;
        }
        String this$appiumPlatformVersion = this.getAppiumPlatformVersion();
        String other$appiumPlatformVersion = other.getAppiumPlatformVersion();
        if (this$appiumPlatformVersion == null ? other$appiumPlatformVersion != null : !this$appiumPlatformVersion.equals(other$appiumPlatformVersion)) {
            return false;
        }
        String this$appiumDeviceName = this.getAppiumDeviceName();
        String other$appiumDeviceName = other.getAppiumDeviceName();
        if (this$appiumDeviceName == null ? other$appiumDeviceName != null : !this$appiumDeviceName.equals(other$appiumDeviceName)) {
            return false;
        }
        String this$appiumApp = this.getAppiumApp();
        String other$appiumApp = other.getAppiumApp();
        if (this$appiumApp == null ? other$appiumApp != null : !this$appiumApp.equals(other$appiumApp)) {
            return false;
        }
        String this$appiumAppPackage = this.getAppiumAppPackage();
        String other$appiumAppPackage = other.getAppiumAppPackage();
        if (this$appiumAppPackage == null ? other$appiumAppPackage != null : !this$appiumAppPackage.equals(other$appiumAppPackage)) {
            return false;
        }
        String this$appiumAppActivity = this.getAppiumAppActivity();
        String other$appiumAppActivity = other.getAppiumAppActivity();
        return !(this$appiumAppActivity == null ? other$appiumAppActivity != null : !this$appiumAppActivity.equals(other$appiumAppActivity));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BrowserConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRemoteDriver() ? 79 : 97);
        String $remoteDriverUrl = this.getRemoteDriverUrl();
        result = result * 59 + ($remoteDriverUrl == null ? 43 : $remoteDriverUrl.hashCode());
        String $downloadDirPath = this.getDownloadDirPath();
        result = result * 59 + ($downloadDirPath == null ? 43 : $downloadDirPath.hashCode());
        Size $sizeOrDevice = this.getSizeOrDevice();
        result = result * 59 + ($sizeOrDevice == null ? 43 : $sizeOrDevice.hashCode());
        BrowserType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $browserBinPath = this.getBrowserBinPath();
        result = result * 59 + ($browserBinPath == null ? 43 : $browserBinPath.hashCode());
        String $webDriverPath = this.getWebDriverPath();
        result = result * 59 + ($webDriverPath == null ? 43 : $webDriverPath.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        result = result * 59 + (this.isDebug() ? 79 : 97);
        result = result * 59 + (this.isSelenoidVnc() ? 79 : 97);
        String $capabilitiesFile = this.getCapabilitiesFile();
        result = result * 59 + ($capabilitiesFile == null ? 43 : $capabilitiesFile.hashCode());
        Parameters $extraParams = this.getExtraParams();
        result = result * 59 + ($extraParams == null ? 43 : $extraParams.hashCode());
        DesiredCapabilities $capabilities = this.getCapabilities();
        result = result * 59 + ($capabilities == null ? 43 : $capabilities.hashCode());
        String $appiumPlatformName = this.getAppiumPlatformName();
        result = result * 59 + ($appiumPlatformName == null ? 43 : $appiumPlatformName.hashCode());
        String $appiumPlatformVersion = this.getAppiumPlatformVersion();
        result = result * 59 + ($appiumPlatformVersion == null ? 43 : $appiumPlatformVersion.hashCode());
        String $appiumDeviceName = this.getAppiumDeviceName();
        result = result * 59 + ($appiumDeviceName == null ? 43 : $appiumDeviceName.hashCode());
        String $appiumApp = this.getAppiumApp();
        result = result * 59 + ($appiumApp == null ? 43 : $appiumApp.hashCode());
        String $appiumAppPackage = this.getAppiumAppPackage();
        result = result * 59 + ($appiumAppPackage == null ? 43 : $appiumAppPackage.hashCode());
        String $appiumAppActivity = this.getAppiumAppActivity();
        result = result * 59 + ($appiumAppActivity == null ? 43 : $appiumAppActivity.hashCode());
        return result;
    }

    public String toString() {
        return "BrowserConfig(remoteDriver=" + this.isRemoteDriver() + ", remoteDriverUrl=" + this.getRemoteDriverUrl() + ", downloadDirPath=" + this.getDownloadDirPath() + ", sizeOrDevice=" + this.getSizeOrDevice() + ", type=" + (Object)((Object)this.getType()) + ", browserBinPath=" + this.getBrowserBinPath() + ", webDriverPath=" + this.getWebDriverPath() + ", version=" + this.getVersion() + ", debug=" + this.isDebug() + ", selenoidVnc=" + this.isSelenoidVnc() + ", capabilitiesFile=" + this.getCapabilitiesFile() + ", extraParams=" + this.getExtraParams() + ", capabilities=" + this.getCapabilities() + ", appiumPlatformName=" + this.getAppiumPlatformName() + ", appiumPlatformVersion=" + this.getAppiumPlatformVersion() + ", appiumDeviceName=" + this.getAppiumDeviceName() + ", appiumApp=" + this.getAppiumApp() + ", appiumAppPackage=" + this.getAppiumAppPackage() + ", appiumAppActivity=" + this.getAppiumAppActivity() + ")";
    }
}

