/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.common;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.AbstractList;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import ru.mk.pump.commons.utils.WaitResult;
import ru.mk.pump.web.common.api.PageItem;
import ru.mk.pump.web.elements.ElementConfig;
import ru.mk.pump.web.elements.ElementFactory;
import ru.mk.pump.web.elements.internal.BaseElement;
import ru.mk.pump.web.exceptions.ElementException;
import ru.mk.pump.web.exceptions.ElementFinderNotFoundException;
import ru.mk.pump.web.utils.Xpath;

public abstract class AbstractPageItemList<T extends PageItem>
extends AbstractList<T> {
    private TIntObjectMap<T> elementsCache = new TIntObjectHashMap();
    protected final BaseElement parent;
    protected final ElementFactory itemFactory;
    protected final Class<T> itemsClass;
    protected final By listBy;
    protected final ElementConfig elementConfig;

    public AbstractPageItemList(@NonNull Class<T> itemsClass, @NonNull By listBy, @NonNull ElementFactory elementFactory, @NonNull ElementConfig itemFactory) {
        this(itemsClass, listBy, null, elementFactory, itemFactory);
        if (itemsClass == null) {
            throw new NullPointerException("itemsClass is marked @NonNull but is null");
        }
        if (listBy == null) {
            throw new NullPointerException("listBy is marked @NonNull but is null");
        }
        if (elementFactory == null) {
            throw new NullPointerException("elementFactory is marked @NonNull but is null");
        }
        if (itemFactory == null) {
            throw new NullPointerException("itemFactory is marked @NonNull but is null");
        }
    }

    public AbstractPageItemList(@NonNull Class<T> itemsClass, @NonNull By listBy, @Nullable BaseElement parent, @NonNull ElementFactory itemFactory, @NonNull ElementConfig elementConfig) {
        if (itemsClass == null) {
            throw new NullPointerException("itemsClass is marked @NonNull but is null");
        }
        if (listBy == null) {
            throw new NullPointerException("listBy is marked @NonNull but is null");
        }
        if (itemFactory == null) {
            throw new NullPointerException("itemFactory is marked @NonNull but is null");
        }
        if (elementConfig == null) {
            throw new NullPointerException("elementConfig is marked @NonNull but is null");
        }
        this.itemsClass = itemsClass;
        this.listBy = Xpath.fixIfXpath(listBy);
        this.parent = parent;
        this.itemFactory = itemFactory;
        this.elementConfig = elementConfig;
    }

    @Override
    public abstract T get(int var1);

    @Override
    public int size() {
        if (this.parent != null) {
            this.parent.getStateResolver().resolve(this.parent.jsReady()).result().throwExceptionOnFail(r -> this.exceptionNoExists((WaitResult<?>)r, this.listBy.toString()));
            this.parent.getStateResolver().resolve(this.parent.exists()).result().throwExceptionOnFail(r -> this.exceptionNoExists((WaitResult<?>)r, this.listBy.toString()));
            WebElement sourceWebElement = (WebElement)this.parent.getFinder().findFast().throwExceptionOnFail(r -> this.exceptionNoExists((WaitResult<?>)r, this.listBy.toString())).getResult();
            return sourceWebElement.findElements(this.listBy).size();
        }
        return this.itemFactory.getBrowser().getDriver().findElements(this.listBy).size();
    }

    @Override
    public T remove(int index) {
        return (T)((PageItem)this.elementsCache.remove(index));
    }

    protected T getCache(int index) {
        return (T)((PageItem)this.elementsCache.get(index));
    }

    protected T saveCache(int index, T item) {
        this.elementsCache.put(index, item);
        return item;
    }

    protected boolean hasCache(int index) {
        return this.elementsCache.containsKey(index);
    }

    private ElementException exceptionNoExists(WaitResult<?> res, String byString) {
        return new ElementFinderNotFoundException(String.format("Cannot find sub rules '%s' by '%s' because parent is not exists", this.itemsClass.getSimpleName(), this.logPath(byString)), res.getCause()).withTargetElement(this.parent);
    }

    private String logPath(String byString) {
        return "parent[" + this.parent.getBy().toString() + "] " + byString;
    }

    @Override
    public String toString() {
        return "AbstractPageItemList(elementsCache=" + this.elementsCache + ", parent=" + this.parent + ", itemFactory=" + this.itemFactory + ", itemsClass=" + this.itemsClass + ", listBy=" + this.listBy + ", elementConfig=" + this.elementConfig + ")";
    }
}

