/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.common.pageobject;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.openqa.selenium.By;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import ru.mk.pump.commons.helpers.Parameters;
import ru.mk.pump.commons.utils.ReflectionUtils;
import ru.mk.pump.web.common.pageobject.FieldElementAnnotation;
import ru.mk.pump.web.component.ComponentList;
import ru.mk.pump.web.component.api.Component;
import ru.mk.pump.web.elements.ElementConfig;
import ru.mk.pump.web.elements.ElementFactory;
import ru.mk.pump.web.elements.ElementList;
import ru.mk.pump.web.elements.api.Element;
import ru.mk.pump.web.elements.internal.BaseElement;

public class Initializer
implements FieldDecorator {
    private final ElementFactory elementFactory;
    private final ElementFactory componentFactory;
    private final BaseElement parent;
    private Class<? extends Element> initClass;
    private Map<Class<? extends Element>, Parameters> elementsImplParametersStore = Maps.newHashMap();

    public Initializer(@NonNull ElementFactory elementFactory, @NonNull ElementFactory componentFactory) {
        this(elementFactory, componentFactory, null);
        if (elementFactory == null) {
            throw new NullPointerException("elementFactory is marked @NonNull but is null");
        }
        if (componentFactory == null) {
            throw new NullPointerException("componentFactory is marked @NonNull but is null");
        }
    }

    public Initializer(@NonNull ElementFactory elementFactory, @NonNull ElementFactory componentFactory, @Nullable BaseElement parent) {
        if (elementFactory == null) {
            throw new NullPointerException("elementFactory is marked @NonNull but is null");
        }
        if (componentFactory == null) {
            throw new NullPointerException("componentFactory is marked @NonNull but is null");
        }
        this.elementFactory = elementFactory;
        this.componentFactory = componentFactory;
        this.parent = parent;
    }

    public Initializer withClassFilter(@Nullable Class<? extends Element> initClass) {
        this.initClass = initClass;
        return this;
    }

    public Object decorate(@NonNull ClassLoader loader, @NonNull Field field) {
        if (loader == null) {
            throw new NullPointerException("loader is marked @NonNull but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked @NonNull but is null");
        }
        FieldElementAnnotation pumpElementAnnotations = new FieldElementAnnotation(field);
        ElementConfig elementConfig = this.annotationsToElementConfig(pumpElementAnnotations);
        By elementBy = pumpElementAnnotations.buildBy();
        if (this.isSingleComponent(field)) {
            Object element = this.parent == null ? this.componentFactory.newElement(field.getType(), elementBy, elementConfig) : this.componentFactory.newElement(field.getType(), elementBy, this.parent, elementConfig);
            if (this.initClass == null) {
                ((Component)element).initAllElements();
            } else {
                ((Component)element).initElementsByClass(this.initClass);
            }
            return element;
        }
        if (this.isListComponent(field)) {
            return new ComponentList(this.getGenericElementClass(field), elementBy, this.parent, this.componentFactory, elementConfig).withInitFilter(this.initClass);
        }
        if (this.isSingleElement(field)) {
            Object element = this.parent == null ? this.elementFactory.newElement(field.getType(), elementBy, elementConfig) : this.elementFactory.newElement(field.getType(), elementBy, this.parent, elementConfig);
            return element;
        }
        if (this.isListElement(field)) {
            return new ElementList(this.getGenericElementClass(field), elementBy, this.parent, this.elementFactory, elementConfig);
        }
        return null;
    }

    protected ElementConfig annotationsToElementConfig(@NonNull FieldElementAnnotation pumpElementAnnotations) {
        if (pumpElementAnnotations == null) {
            throw new NullPointerException("pumpElementAnnotations is marked @NonNull but is null");
        }
        return ElementConfig.of(pumpElementAnnotations.getElementName(), pumpElementAnnotations.getElementDescription()).withParameters(this.getParameterIfCan(pumpElementAnnotations)).withParameters(pumpElementAnnotations.buildParameters()).withRequirements(pumpElementAnnotations.getRequirements());
    }

    private Parameters getParameterIfCan(@NonNull FieldElementAnnotation pumpElementAnnotations) {
        if (pumpElementAnnotations == null) {
            throw new NullPointerException("pumpElementAnnotations is marked @NonNull but is null");
        }
        if (this.isSingleElement(pumpElementAnnotations.getField())) {
            return this.getElementsImplParametersStore().getOrDefault(pumpElementAnnotations.getField().getType(), Parameters.of());
        }
        if (this.isListElement(pumpElementAnnotations.getField())) {
            return this.getElementsImplParametersStore().getOrDefault(this.getGenericElementClass(pumpElementAnnotations.getField()), Parameters.of());
        }
        return Parameters.of();
    }

    private boolean isNotFinal(Field field) {
        return !Modifier.isFinal(field.getModifiers());
    }

    private boolean isSuccessFiltered(Class<?> clazz) {
        return this.initClass == null || this.initClass.isAssignableFrom(clazz);
    }

    private boolean isSingleElement(Field field) {
        return Element.class.isAssignableFrom(field.getType()) && this.isSuccessFiltered(field.getType()) && this.isNotFinal(field);
    }

    private boolean isSingleComponent(Field field) {
        return Component.class.isAssignableFrom(field.getType()) && this.isSuccessFiltered(field.getType()) && this.isNotFinal(field);
    }

    private boolean isListElement(Field field) {
        return List.class.isAssignableFrom(field.getType()) && Element.class.isAssignableFrom(ReflectionUtils.getGenericParameterField((Field)field, (int)0)) && this.isSuccessFiltered(field.getType()) && this.isNotFinal(field);
    }

    private boolean isListComponent(Field field) {
        return List.class.isAssignableFrom(field.getType()) && Component.class.isAssignableFrom(ReflectionUtils.getGenericParameterField((Field)field, (int)0)) && this.isSuccessFiltered(field.getType()) && this.isNotFinal(field);
    }

    private <T extends Element> Class<T> getGenericElementClass(Field field) {
        try {
            return ReflectionUtils.getGenericParameterField((Field)field, (int)0);
        }
        catch (ClassCastException ex) {
            throw new InternalError("Pump-fw internal error. Unexpectedly using private method without required checks in Initializer. Contact to developer", ex);
        }
    }

    public ElementFactory getElementFactory() {
        return this.elementFactory;
    }

    public ElementFactory getComponentFactory() {
        return this.componentFactory;
    }

    public void setElementsImplParametersStore(Map<Class<? extends Element>, Parameters> elementsImplParametersStore) {
        this.elementsImplParametersStore = elementsImplParametersStore;
    }

    public Map<Class<? extends Element>, Parameters> getElementsImplParametersStore() {
        return this.elementsImplParametersStore;
    }
}

