/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.component.api;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import ru.mk.pump.commons.interfaces.StrictInfo;
import ru.mk.pump.web.common.api.PageItem;
import ru.mk.pump.web.common.api.PageItemImplDispatcher;
import ru.mk.pump.web.common.pageobject.Initializer;
import ru.mk.pump.web.elements.ElementImplDispatcher;
import ru.mk.pump.web.elements.api.Element;
import ru.mk.pump.web.elements.internal.BaseElement;

public interface Component
extends PageItem {
    default public void initAllElements() {
        PageFactory.initElements((FieldDecorator)this.getInitializer(), (Object)this);
    }

    default public void initElementsByClass(Class<? extends Element> initClass) {
        PageFactory.initElements((FieldDecorator)this.getInitializer().withClassFilter(initClass), (Object)this);
    }

    public static PageItemImplDispatcher getImplDispatcher() {
        return new PageItemImplDispatcher(){

            @Override
            public <R extends BaseElement> ElementImplDispatcher.ElementImpl<R> findImplementation(@NonNull Class<? extends Element> elementInterface, @Nullable Set<Class<? extends Annotation>> requirements) {
                if (elementInterface == null) {
                    throw new NullPointerException("elementInterface is marked @NonNull but is null");
                }
                try {
                    return ElementImplDispatcher.ElementImpl.of(elementInterface, null);
                }
                catch (ClassCastException ex) {
                    throw new InternalError("Error in Component Dispatcher", ex);
                }
            }

            public Map<String, String> getInfo() {
                return StrictInfo.infoBuilder((String)"component impl dispatcher").build();
            }
        };
    }

    public void check();

    public Initializer getInitializer();

    public String getText();
}

