/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.configuration;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.concurrent.locks.ReentrantLock;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.config.ConfigurationHelper;
import ru.mk.pump.commons.config.ConfigurationsLoader;
import ru.mk.pump.web.browsers.configuration.BrowserConfig;
import ru.mk.pump.web.browsers.configuration.BrowserType;
import ru.mk.pump.web.configuration.Configuration;

public class ConfigurationHolder {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationHolder.class);
    public static final String DEFAULT_SYSTEM_ENV_NAME = "pump.configuration.path";
    public static final String DEFAULT_CLASSPATH_RESOURCE = "pump.properties";
    private static final Object lock = new Object();
    private static final ReentrantLock rLock = new ReentrantLock();
    private static volatile ConfigurationHolder INSTANCE;
    private final ConfigurationHelper<Configuration> configurationHelper;

    private ConfigurationHolder(Configuration configuration) {
        this.configurationHelper = new ConfigurationHelper(DEFAULT_SYSTEM_ENV_NAME, DEFAULT_CLASSPATH_RESOURCE, (Object)configuration);
    }

    public static void cleanup() {
        INSTANCE = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationHolder instance() {
        ConfigurationHolder localInstance = INSTANCE;
        if (localInstance == null) {
            Object object = lock;
            synchronized (object) {
                localInstance = INSTANCE;
                if (localInstance == null) {
                    INSTANCE = localInstance = new ConfigurationHolder(ConfigurationHolder.getDefaultConfiguration());
                }
            }
        }
        return localInstance;
    }

    public static Configuration get() {
        Configuration localInstance = (Configuration)ConfigurationHolder.instance().configurationHelper.config();
        if (localInstance != null) {
            return localInstance;
        }
        if (rLock.tryLock()) {
            rLock.lock();
            ConfigurationHolder.instance().configurationHelper.loadAuto();
            rLock.unlock();
        }
        return (Configuration)ConfigurationHolder.instance().configurationHelper.config();
    }

    public static void init(ConfigurationsLoader configurationsLoader) {
        ConfigurationHolder.instance().configurationHelper.loadFromLoader(configurationsLoader);
    }

    public static void init(@NonNull InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked @NonNull but is null");
        }
        ConfigurationHolder.instance().configurationHelper.loadFromStream(inputStream);
    }

    public static void init(@NonNull String resourcePath) {
        if (resourcePath == null) {
            throw new NullPointerException("resourcePath is marked @NonNull but is null");
        }
        ConfigurationHolder.instance().configurationHelper.loadFromResource(resourcePath);
    }

    public static void init(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path is marked @NonNull but is null");
        }
        ConfigurationHolder.instance().configurationHelper.loadFromFile(path);
    }

    public static void initSystemEnv(String envVarWithResourceNameInClassPath) {
        ConfigurationHolder.instance().configurationHelper.loadFromSystemEnv(envVarWithResourceNameInClassPath);
    }

    public static void initDefault() {
        ConfigurationHolder.instance().configurationHelper.loadAuto();
    }

    private static Configuration getDefaultConfiguration() {
        Configuration config = new Configuration();
        config.setBrowserConfig(BrowserConfig.of(BrowserType.CHROME));
        config.setApplicationName("undefined");
        config.getElement().setWindowWidthOffset(-1);
        return config;
    }

    public ConfigurationHelper<Configuration> getConfigurationHelper() {
        return this.configurationHelper;
    }
}

