/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.elements;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.NonNull;
import ru.mk.pump.commons.helpers.Parameter;
import ru.mk.pump.commons.helpers.Parameters;
import ru.mk.pump.commons.reporter.Reporter;
import ru.mk.pump.commons.utils.Verifier;

public class ElementConfig {
    private Set<Class<? extends Annotation>> requirements = Sets.newHashSet();
    private Parameters parameters = Parameters.of();
    private int index = -1;
    private String name = "";
    private String description = "";
    private Verifier verifier;
    private Reporter reporter;

    public static ElementConfig of(String name) {
        return new ElementConfig().withName(name);
    }

    public static ElementConfig of(String name, String description) {
        return new ElementConfig().withName(name).withDescription(description);
    }

    public ElementConfig withRequirements(@NonNull Collection<Class<? extends Annotation>> requirements) {
        if (requirements == null) {
            throw new NullPointerException("requirements is marked @NonNull but is null");
        }
        this.requirements.addAll(requirements);
        return this;
    }

    public ElementConfig addRequirement(@NonNull Class<? extends Annotation> requirement) {
        if (requirement == null) {
            throw new NullPointerException("requirement is marked @NonNull but is null");
        }
        this.requirements.add(requirement);
        return this;
    }

    public ElementConfig withParameters(@NonNull Parameters parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked @NonNull but is null");
        }
        this.parameters.addAll(parameters);
        return this;
    }

    public ElementConfig addParameter(@NonNull String key, Parameter value) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        this.parameters.add(value.withName(key));
        return this;
    }

    public ElementConfig withIndex(int index) {
        this.index = index;
        return this;
    }

    public ElementConfig withName(@Nullable String name) {
        this.name = name;
        return this;
    }

    public ElementConfig withVerifier(@Nullable Verifier verifier) {
        this.verifier = verifier;
        return this;
    }

    public ElementConfig withReporter(@Nullable Reporter reporter) {
        this.reporter = reporter;
        return this;
    }

    public ElementConfig withDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    public Set<Class<? extends Annotation>> getRequirements() {
        return this.requirements;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Verifier getVerifier() {
        return this.verifier;
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public String toString() {
        return "ElementConfig(requirements=" + this.getRequirements() + ", parameters=" + this.getParameters() + ", index=" + this.getIndex() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", verifier=" + this.getVerifier() + ", reporter=" + this.getReporter() + ")";
    }
}

