/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.elements;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.openqa.selenium.By;
import ru.mk.pump.commons.exception.PumpMessage;
import ru.mk.pump.commons.interfaces.StrictInfo;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.web.browsers.Browser;
import ru.mk.pump.web.common.api.PageItemImplDispatcher;
import ru.mk.pump.web.elements.ElementConfig;
import ru.mk.pump.web.elements.ElementImplDispatcher;
import ru.mk.pump.web.elements.api.Element;
import ru.mk.pump.web.elements.api.listeners.ActionListener;
import ru.mk.pump.web.elements.api.listeners.StateListener;
import ru.mk.pump.web.elements.internal.BaseElement;
import ru.mk.pump.web.elements.internal.interfaces.InternalElement;
import ru.mk.pump.web.exceptions.ElementFactoryException;
import ru.mk.pump.web.page.api.Page;

public class ElementFactory
implements StrictInfo {
    private final Page page;
    private final PageItemImplDispatcher elementImplDispatcher;
    private final Browser browser;
    private Set<Class<? extends Annotation>> requirements = Sets.newHashSet();
    private List<ActionListener> actionListeners = Lists.newArrayList();
    private List<StateListener> stateListeners = Lists.newArrayList();

    public ElementFactory(@NonNull PageItemImplDispatcher elementImplDispatcher, @NonNull Page page) {
        if (elementImplDispatcher == null) {
            throw new NullPointerException("elementImplDispatcher is marked @NonNull but is null");
        }
        if (page == null) {
            throw new NullPointerException("page is marked @NonNull but is null");
        }
        this.elementImplDispatcher = elementImplDispatcher;
        this.page = page;
        this.browser = page.getBrowser();
    }

    public ElementFactory(@NonNull PageItemImplDispatcher elementImplDispatcher, @NonNull Browser browser) {
        if (elementImplDispatcher == null) {
            throw new NullPointerException("elementImplDispatcher is marked @NonNull but is null");
        }
        if (browser == null) {
            throw new NullPointerException("browser is marked @NonNull but is null");
        }
        this.elementImplDispatcher = elementImplDispatcher;
        this.browser = browser;
        this.page = null;
    }

    public ElementFactory addMainRequirements(@NonNull Class<? extends Annotation>[] requirements) {
        if (requirements == null) {
            throw new NullPointerException("requirements is marked @NonNull but is null");
        }
        this.requirements.addAll(Arrays.asList(requirements));
        return this;
    }

    public ElementFactory addActionListener(@NonNull ActionListener actionListener) {
        if (actionListener == null) {
            throw new NullPointerException("actionListener is marked @NonNull but is null");
        }
        this.actionListeners.add(actionListener);
        return this;
    }

    public ElementFactory withActionListener(@NonNull Collection<ActionListener> actionListener) {
        if (actionListener == null) {
            throw new NullPointerException("actionListener is marked @NonNull but is null");
        }
        this.actionListeners.addAll(actionListener);
        return this;
    }

    public ElementFactory addStateListener(@NonNull StateListener stateListener) {
        if (stateListener == null) {
            throw new NullPointerException("stateListener is marked @NonNull but is null");
        }
        this.stateListeners.add(stateListener);
        return this;
    }

    public ElementFactory withStateListener(@NonNull Collection<StateListener> stateListeners) {
        if (stateListeners == null) {
            throw new NullPointerException("stateListeners is marked @NonNull but is null");
        }
        this.stateListeners.addAll(stateListeners);
        return this;
    }

    public <R extends Element> R newElement(@NonNull Class<R> interfaceClass, @NonNull By by, @NonNull ElementConfig elementConfig) {
        if (interfaceClass == null) {
            throw new NullPointerException("interfaceClass is marked @NonNull but is null");
        }
        if (by == null) {
            throw new NullPointerException("by is marked @NonNull but is null");
        }
        if (elementConfig == null) {
            throw new NullPointerException("elementConfig is marked @NonNull but is null");
        }
        ElementImplDispatcher.ElementImpl elementImplClass = this.elementImplDispatcher.findImplementation(interfaceClass, this.getRequirements(elementConfig));
        try {
            if (this.page == null) {
                Constructor constructor = elementImplClass.getImplementation().getConstructor(By.class, Browser.class);
                constructor.setAccessible(true);
                return (R)this.fillElement((BaseElement)constructor.newInstance(by, this.browser), elementConfig);
            }
            Constructor constructor = elementImplClass.getImplementation().getConstructor(By.class, Page.class);
            constructor.setAccessible(true);
            return (R)this.fillElement((BaseElement)constructor.newInstance(by, this.page), elementConfig);
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new ElementFactoryException(new PumpMessage(String.format("Error when try to creating element with interface '%s'", interfaceClass.getCanonicalName())).addExtraInfo("by", Strings.toString((Object)by)).addExtraInfo("elementConfig", Strings.toString((Object)elementConfig)).addExtraInfo("factory", (StrictInfo)this), (Throwable)ex);
        }
    }

    public <R extends Element> R newElement(@NonNull Class<R> interfaceClass, @NonNull By by, @NonNull Element parent, @NonNull ElementConfig elementConfig) {
        if (interfaceClass == null) {
            throw new NullPointerException("interfaceClass is marked @NonNull but is null");
        }
        if (by == null) {
            throw new NullPointerException("by is marked @NonNull but is null");
        }
        if (parent == null) {
            throw new NullPointerException("parent is marked @NonNull but is null");
        }
        if (elementConfig == null) {
            throw new NullPointerException("elementConfig is marked @NonNull but is null");
        }
        this.checkParent(parent);
        ElementImplDispatcher.ElementImpl elementImplClass = this.elementImplDispatcher.findImplementation(interfaceClass, this.getRequirements(elementConfig));
        try {
            Constructor constructor = elementImplClass.getImplementation().getConstructor(By.class, InternalElement.class);
            constructor.setAccessible(true);
            return (R)this.fillElement((BaseElement)constructor.newInstance(by, (InternalElement)((Object)parent)), elementConfig);
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new ElementFactoryException(new PumpMessage(String.format("Error when try to creating element with interface '%s'", interfaceClass.getCanonicalName())).addExtraInfo("by", Strings.toString((Object)by)).addExtraInfo("elementConfig", Strings.toString((Object)elementConfig)).addExtraInfo("factory", (StrictInfo)this).addExtraInfo("parent", (StrictInfo)parent), (Throwable)ex);
        }
    }

    public Map<String, String> getInfo() {
        LinkedHashMap res = Maps.newLinkedHashMap();
        if (this.browser != null) {
            res.put("browser", this.browser.getId());
        }
        if (this.page != null) {
            res.put("page", this.page.getName());
        }
        if (!this.requirements.isEmpty()) {
            res.put("requirements", Strings.toPrettyString(this.requirements));
        }
        res.put("actionListeners", String.valueOf(this.actionListeners.size()));
        res.put("stateListeners", String.valueOf(this.stateListeners.size()));
        res.put("impl dispatcher", Strings.toPrettyString((Map)this.elementImplDispatcher.getInfo()));
        return res;
    }

    private void checkParent(Element parent) throws ElementFactoryException {
        if (!(parent instanceof InternalElement)) {
            throw new ElementFactoryException(new PumpMessage(String.format("Parent element '%s' is not accessible expected interface '%s'", parent.getClass().getSimpleName(), InternalElement.class.getSimpleName())).addExtraInfo(this.getInfo()));
        }
    }

    private Set<Class<? extends Annotation>> getRequirements(ElementConfig elementConfig) {
        return ImmutableSet.builder().addAll(elementConfig.getRequirements()).addAll(this.requirements).build();
    }

    private <R extends BaseElement> R fillElement(R element, ElementConfig elementConfig) {
        ((BaseElement)((BaseElement)element.setSelfFactory(this).withParams(elementConfig.getParameters()).setName(elementConfig.getName())).setDescription(elementConfig.getDescription())).setReporter(elementConfig.getReporter()).withVerifier(elementConfig.getVerifier()).addActionListener((List)this.actionListeners);
        element.addStateListener((List)this.stateListeners);
        if (elementConfig.getIndex() != -1) {
            element.setIndex(elementConfig.getIndex());
        }
        return element;
    }

    public String toString() {
        return "ElementFactory(page=" + this.getPage() + ", browser=" + this.getBrowser() + ", requirements=" + this.requirements + ", actionListeners=" + this.actionListeners + ", stateListeners=" + this.stateListeners + ")";
    }

    public Page getPage() {
        return this.page;
    }

    public PageItemImplDispatcher getElementImplDispatcher() {
        return this.elementImplDispatcher;
    }

    public Browser getBrowser() {
        return this.browser;
    }
}

