/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.elements;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.exception.PumpMessage;
import ru.mk.pump.commons.helpers.Parameters;
import ru.mk.pump.commons.interfaces.StrictInfo;
import ru.mk.pump.commons.utils.ReflectionUtils;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.web.common.api.PageItemImplDispatcher;
import ru.mk.pump.web.configuration.ConfigurationHolder;
import ru.mk.pump.web.elements.api.Element;
import ru.mk.pump.web.elements.api.annotations.CustomImpl;
import ru.mk.pump.web.elements.api.annotations.FrameworkImpl;
import ru.mk.pump.web.elements.api.annotations.Requirements;
import ru.mk.pump.web.elements.internal.BaseElement;
import ru.mk.pump.web.exceptions.ElementDiscoveryException;

public class ElementImplDispatcher
implements PageItemImplDispatcher {
    private static final Logger log = LoggerFactory.getLogger(ElementImplDispatcher.class);
    private static final Class<? extends Annotation> DEFAULT_ANNOTATION_IMPL = FrameworkImpl.class;
    private static final Class<? extends Annotation> DEFAULT_ANNOTATION_CUSTOM = CustomImpl.class;
    private static final String[] DEFAULT_PACKAGE_IMPL = new String[]{"ru.mk.pump.web.elements.internal.impl"};
    private static final String[] DEFAULT_PACKAGE_INTERFACE = new String[]{"ru.mk.pump.web.elements.api.concrete"};
    public static String[] customPackagesImpl = ConfigurationHolder.get().getElement().getPackagesImpl();
    public static String[] customPackagesInterface = ConfigurationHolder.get().getElement().getPackagesInterface();
    private final SetMultimap<Class<? extends Element>, ElementImpl<? extends BaseElement>> interfaceToImplMap;

    public ElementImplDispatcher() {
        this((SetMultimap<Class<? extends Element>, ElementImpl<? extends BaseElement>>)HashMultimap.create());
    }

    public ElementImplDispatcher(SetMultimap<Class<? extends Element>, ElementImpl<? extends BaseElement>> interfaceToImplMap) {
        this.interfaceToImplMap = interfaceToImplMap;
        this.loadDefault();
    }

    @Override
    public <R extends BaseElement> ElementImpl<R> findImplementation(@NonNull Class<? extends Element> elementInterface, @Nullable Set<Class<? extends Annotation>> requirements) {
        if (elementInterface == null) {
            throw new NullPointerException("elementInterface is marked @NonNull but is null");
        }
        ElementImpl<R> result = this.findByElementConfig(elementInterface, requirements);
        log.debug("[ElementImplDispatcher] find implementation for interface '{}' is '{}'", elementInterface, result);
        return result;
    }

    public <T extends Element, V extends BaseElement> ElementImplDispatcher addImplementation(@NonNull Class<T> elementInterface, @NonNull ElementImpl<V> elementImplementation) {
        if (elementInterface == null) {
            throw new NullPointerException("elementInterface is marked @NonNull but is null");
        }
        if (elementImplementation == null) {
            throw new NullPointerException("elementImplementation is marked @NonNull but is null");
        }
        this.interfaceToImplMap.put(elementInterface, elementImplementation);
        return null;
    }

    public Multimap<Class<? extends Element>, ElementImpl<? extends BaseElement>> getAll() {
        return this.interfaceToImplMap;
    }

    public <T extends BaseElement> long addParams(@NonNull Class<T> elementImpl, @NonNull Parameters parameters) {
        if (elementImpl == null) {
            throw new NullPointerException("elementImpl is marked @NonNull but is null");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters is marked @NonNull but is null");
        }
        return this.getAll().values().stream().filter(impl -> elementImpl.isAssignableFrom(impl.getImplementation())).map(impl -> impl.setParameters(parameters)).count();
    }

    public Map<String, String> getInfo() {
        LinkedHashMap res = Maps.newLinkedHashMap();
        res.put("PACKAGE_INTERFACE", Arrays.toString(ArrayUtils.addAll((Object[])DEFAULT_PACKAGE_INTERFACE, (Object[])customPackagesInterface)));
        res.put("PACKAGE_IMPL", Arrays.toString(ArrayUtils.addAll((Object[])DEFAULT_PACKAGE_IMPL, (Object[])customPackagesImpl)));
        res.put("DEFAULT_ANNOTATION_IMPL", DEFAULT_ANNOTATION_IMPL.getSimpleName());
        this.interfaceToImplMap.asMap().forEach((key, value) -> res.put(key.getSimpleName(), Strings.toPrettyString((Collection)value)));
        return res;
    }

    protected void loadDefault() {
        Set implementations = ReflectionUtils.getAllClasses(BaseElement.class, (String[])((String[])ArrayUtils.addAll((Object[])DEFAULT_PACKAGE_IMPL, (Object[])customPackagesImpl)));
        Set interfaces = ReflectionUtils.getAllClasses(Element.class, (String[])((String[])ArrayUtils.addAll((Object[])DEFAULT_PACKAGE_INTERFACE, (Object[])customPackagesInterface)));
        for (Class aClass : interfaces.stream().filter(Class::isInterface).collect(Collectors.toList())) {
            this.interfaceToImplMap.putAll((Object)aClass, (Iterable)implementations.stream().filter(cls -> ReflectionUtils.hasInterfaceOrSuperclass((Class)aClass, (Class)cls)).map(item -> ElementImpl.of(item, null)).collect(Collectors.toList()));
        }
        this.addImplementation(Element.class, ElementImpl.of(BaseElement.class, null));
        log.debug("[ElementImplDispatcher] implementation load - success : {}", (Object)Strings.toPrettyString(this.getInfo()));
    }

    private <T extends Element, R extends BaseElement> ElementImpl<R> findByElementConfig(Class<T> elementInterface, @Nullable Set<Class<? extends Annotation>> requirements) {
        if (!this.interfaceToImplMap.containsKey(elementInterface)) {
            throw new ElementDiscoveryException(new PumpMessage(String.format("Interface '%s' do not exists in ElementImplDispatcher. You have to add this using #addImplementation", elementInterface.getSimpleName())).addEnvInfo((StrictInfo)this));
        }
        Set implementations = this.interfaceToImplMap.get(elementInterface);
        if (implementations.isEmpty()) {
            throw new ElementDiscoveryException(new PumpMessage(String.format("Interface '%s' do not have any implementations  in ElementImplDispatcher. You have to add using #addImplementation", elementInterface.getSimpleName())).addEnvInfo((StrictInfo)this));
        }
        Optional<Object> expectedImpl = Optional.empty();
        if (requirements != null && !requirements.isEmpty() && !(expectedImpl = implementations.stream().filter(item -> requirements.stream().filter(a -> a.isAnnotationPresent(Requirements.class)).allMatch(an -> item.getImplementation().isAnnotationPresent((Class<Annotation>)an))).min(Comparator.comparingInt(e -> e.getImplementation().getAnnotations().length))).isPresent()) {
            log.warn("[ElementImplDispatcher] Cannot find implementation with all of this annotations '{}'", requirements);
        }
        if (!expectedImpl.isPresent()) {
            expectedImpl = implementations.stream().filter(item -> item.getImplementation().isAnnotationPresent(DEFAULT_ANNOTATION_CUSTOM)).min(Comparator.comparingInt(e -> e.getImplementation().getAnnotations().length));
        }
        if (!expectedImpl.isPresent()) {
            expectedImpl = implementations.stream().filter(item -> item.getImplementation().isAnnotationPresent(DEFAULT_ANNOTATION_IMPL)).min(Comparator.comparingInt(e -> e.getImplementation().getAnnotations().length));
        }
        if (expectedImpl.isPresent()) {
            return (ElementImpl)expectedImpl.orElseThrow(UnknownError::new);
        }
        log.debug("[ElementImplDispatcher] Cannot find implementation of '{}' with default annotation '{}'", elementInterface, DEFAULT_ANNOTATION_IMPL);
        return (ElementImpl)implementations.iterator().next();
    }

    public String toString() {
        return "ElementImplDispatcher(DEFAULT_ANNOTATION_IMPL=" + DEFAULT_ANNOTATION_IMPL + ", DEFAULT_PACKAGE_IMPL=" + Arrays.deepToString(DEFAULT_PACKAGE_IMPL) + ", DEFAULT_PACKAGE_INTERFACE=" + Arrays.deepToString(DEFAULT_PACKAGE_INTERFACE) + ", customPackagesImpl=" + Arrays.deepToString(customPackagesImpl) + ", customPackagesInterface=" + Arrays.deepToString(customPackagesInterface) + ", interfaceToImplMap=" + this.interfaceToImplMap + ")";
    }

    public static void setCustomPackagesImpl(String[] customPackagesImpl) {
        ElementImplDispatcher.customPackagesImpl = customPackagesImpl;
    }

    public static void setCustomPackagesInterface(String[] customPackagesInterface) {
        ElementImplDispatcher.customPackagesInterface = customPackagesInterface;
    }

    public static class ElementImpl<T extends BaseElement> {
        private final Class<T> implementation;
        private Parameters parameters;

        private ElementImpl(@NonNull Class<T> implementation, @Nullable Parameters parameters) {
            if (implementation == null) {
                throw new NullPointerException("implementation is marked @NonNull but is null");
            }
            this.implementation = implementation;
            this.parameters = parameters;
        }

        public static <T extends BaseElement> ElementImpl<T> of(@NonNull Class<T> implementation, @Nullable Parameters parameters) {
            if (implementation == null) {
                throw new NullPointerException("implementation is marked @NonNull but is null");
            }
            return new ElementImpl<T>(implementation, parameters);
        }

        public ElementImpl<T> setParameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ElementImpl(");
            sb.append("implementation=").append(this.implementation.getName());
            if (this.parameters != null && !this.parameters.isEmpty()) {
                sb.append(", parameters=").append(this.parameters);
            }
            sb.append(')');
            return sb.toString();
        }

        public Class<T> getImplementation() {
            return this.implementation;
        }

        public Parameters getParameters() {
            return this.parameters;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ElementImpl)) {
                return false;
            }
            ElementImpl other = (ElementImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<T> this$implementation = this.getImplementation();
            Class<T> other$implementation = other.getImplementation();
            return !(this$implementation == null ? other$implementation != null : !this$implementation.equals(other$implementation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ElementImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<T> $implementation = this.getImplementation();
            result = result * 59 + ($implementation == null ? 43 : $implementation.hashCode());
            return result;
        }
    }
}

