/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.elements.api.concrete.complex;

import java.util.Arrays;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.openqa.selenium.By;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.helpers.Parameters;
import ru.mk.pump.commons.utils.ParameterUtils;
import ru.mk.pump.commons.utils.Preconditions;
import ru.mk.pump.web.elements.api.Element;
import ru.mk.pump.web.elements.internal.BaseElement;

public class Child<T extends Element> {
    private static final Logger log = LoggerFactory.getLogger(Child.class);
    private final BaseElement parentElement;
    private final String parameterName;
    private By[] defaultByArray;
    private T cache;

    public Child(@NonNull BaseElement parentElement, @Nullable String parameterName) {
        if (parentElement == null) {
            throw new NullPointerException("parentElement is marked @NonNull but is null");
        }
        Preconditions.checkStringNotBlank((String)parameterName);
        this.parameterName = parameterName;
        this.parentElement = parentElement;
    }

    public Child(@NonNull BaseElement parentElement, @NonNull By[] childByArray) {
        if (parentElement == null) {
            throw new NullPointerException("parentElement is marked @NonNull but is null");
        }
        if (childByArray == null) {
            throw new NullPointerException("childByArray is marked @NonNull but is null");
        }
        this.parameterName = null;
        this.parentElement = parentElement;
        this.withDefaultBy(childByArray);
    }

    public Child<T> withDefaultBy(@Nullable By[] defaultByArray) {
        this.defaultByArray = defaultByArray;
        return this;
    }

    public T find(Class<T> childClass) {
        log.trace("Child.find call : {}", childClass);
        this.cache = this.parentElement.getSubElements(childClass).find(this.extractBys());
        log.trace("Child.find return : {}", this.cache.getClass());
        return this.cache;
    }

    public T get(Class<T> childClass) {
        log.trace("Child.get call : {}", childClass);
        if (this.cache == null) {
            log.trace("Child.get return : call #find");
            return this.find(childClass);
        }
        log.trace("Child.get return from cache : {}", this.cache.getClass());
        return this.cache;
    }

    public boolean isDefined() {
        return ArrayUtils.isNotEmpty((Object[])this.extractBys());
    }

    private By[] extractBys() {
        this.defaultByArray = (By[])ParameterUtils.getOrDefault((Parameters)this.parentElement.getParams(), (String)this.parameterName, By[].class, (Object)this.defaultByArray);
        return this.defaultByArray;
    }

    public String toString() {
        return "Child(parameterName=" + this.getParameterName() + ", defaultByArray=" + Arrays.deepToString(this.defaultByArray) + ")";
    }

    public String getParameterName() {
        return this.parameterName;
    }
}

