/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.elements.internal;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.openqa.selenium.WebElement;
import ru.mk.pump.commons.helpers.Parameters;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.web.elements.enums.ActionStrategy;
import ru.mk.pump.web.elements.internal.SetState;
import ru.mk.pump.web.elements.internal.interfaces.Action;
import ru.mk.pump.web.elements.internal.interfaces.InternalElement;

abstract class AbstractAction<T>
implements Action<T> {
    private static final int MAX_TRY = 5;
    private int maxTruCount = 5;
    private final BiFunction<WebElement, Parameters, T> actionSupplier;
    private final InternalElement internalElement;
    private final String name;
    private int actionExecutionTry = 0;
    private Action.ActionStage currentStage;
    private Set<ActionStrategy> actionStrategies = Sets.newHashSet();
    private Parameters parameters = Parameters.of();
    private SetState stateSet;

    AbstractAction(BiFunction<WebElement, Parameters, T> actionFunction, InternalElement internalElement, String name) {
        this.actionSupplier = actionFunction;
        this.internalElement = internalElement;
        this.name = name;
    }

    @Override
    public T get() {
        RuntimeException ex = null;
        Error error = null;
        this.actionExecutionTry = 0;
        while (this.actionExecutionTry < this.maxTruCount) {
            try {
                ++this.actionExecutionTry;
                return this.actionSupplier.apply(this.getInteractElement(), this.getParameters());
            }
            catch (RuntimeException ignore) {
                ex = ignore;
            }
            catch (Error ignore) {
                error = ignore;
            }
        }
        if (ex != null) {
            throw ex;
        }
        throw error;
    }

    @Override
    public Action.ActionStage getStage() {
        return this.currentStage;
    }

    @Override
    public void setStage(Action.ActionStage currentStage) {
        this.currentStage = currentStage;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public InternalElement getTarget() {
        return this.internalElement;
    }

    @Override
    public Action<T> withParameters(Parameters parameters) {
        this.parameters.addAll(parameters);
        return this;
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public int getTry() {
        return this.actionExecutionTry;
    }

    @Override
    public SetState getRedefineState() {
        return this.stateSet;
    }

    @Override
    public Set<ActionStrategy> getStrategy() {
        return this.actionStrategies;
    }

    @Override
    public Action<T> redefineExpectedState(SetState stateSet) {
        this.stateSet = stateSet;
        return this;
    }

    @Override
    public AbstractAction<T> setMaxTruCount(int maxTruCount) {
        this.maxTruCount = maxTruCount;
        return this;
    }

    @Override
    public Action<T> withStrategy(ActionStrategy ... strategies) {
        this.actionStrategies.addAll(Arrays.asList(strategies));
        return this;
    }

    public Map<String, String> getInfo() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("type", this.name);
        result.put("try", String.valueOf(this.actionExecutionTry));
        result.put("action strategies", Strings.toString(this.actionStrategies));
        result.put("current stage", this.currentStage.toString());
        result.put("target element", Strings.space((String[])new String[]{this.internalElement.getName(), this.internalElement.getBy().toString()}));
        result.put("parameters", this.parameters.toString());
        result.put("max tries", String.valueOf(this.maxTruCount));
        if (this.stateSet != null) {
            result.put("redefined stateSet", this.stateSet.toString());
        }
        return result;
    }

    WebElement getInteractElement() {
        return (WebElement)this.internalElement.getFinder().findFast().throwExceptionOnFail().getResult();
    }

    public String toString() {
        return "AbstractAction(maxTruCount=" + this.maxTruCount + ", internalElement=" + this.internalElement + ", name=" + this.name + ", actionExecutionTry=" + this.actionExecutionTry + ", currentStage=" + (Object)((Object)this.currentStage) + ", actionStrategies=" + this.actionStrategies + ", parameters=" + this.getParameters() + ")";
    }
}

