/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.elements.internal;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.commons.utils.WaitResult;
import ru.mk.pump.web.browsers.Browser;
import ru.mk.pump.web.elements.api.listeners.ActionListener;
import ru.mk.pump.web.elements.api.listeners.StateListener;
import ru.mk.pump.web.elements.enums.StateType;
import ru.mk.pump.web.elements.internal.ActionExecutor;
import ru.mk.pump.web.elements.internal.ActionFactory;
import ru.mk.pump.web.elements.internal.ActionsStore;
import ru.mk.pump.web.elements.internal.ElementWaiter;
import ru.mk.pump.web.elements.internal.Finder;
import ru.mk.pump.web.elements.internal.ListElementStrategy;
import ru.mk.pump.web.elements.internal.SetState;
import ru.mk.pump.web.elements.internal.State;
import ru.mk.pump.web.elements.internal.StateResolver;
import ru.mk.pump.web.elements.internal.interfaces.Action;
import ru.mk.pump.web.elements.internal.interfaces.InternalElement;
import ru.mk.pump.web.page.api.Page;
import ru.mk.pump.web.utils.Xpath;

abstract class AbstractElement<CHILD>
implements InternalElement {
    public static boolean JS_WAIT = false;
    private final By avatarBy;
    private final ElementWaiter waiter;
    private final Browser browser;
    private final InternalElement parentElement;
    private final ActionExecutor actionExecutor;
    private final StateResolver stateResolver;
    private final Finder finder;
    private final Consumer<WaitResult<Boolean>> TEAR_DOWN = stateWaitResult -> this.getFinder().getLast().ifPresent(waitResult -> stateWaitResult.withCause(waitResult.getCause()));
    private final ActionsStore actionsStore;
    protected boolean xpathAutoFix = true;
    private String elementName;
    private String elementDescription = "nonArg (recommend to add)";
    private final Page page;
    private int listIndex = -1;

    public AbstractElement(By avatarBy, Page page) {
        this(avatarBy, null, null, page);
    }

    public AbstractElement(By avatarBy, InternalElement parentElement) {
        this(avatarBy, parentElement, null, null);
    }

    public AbstractElement(By avatarBy, Browser browser) {
        this(avatarBy, null, browser, null);
    }

    private AbstractElement(@NonNull By avatarBy, @Nullable InternalElement parentElement, @Nullable Browser browser, @Nullable Page page) {
        if (avatarBy == null) {
            throw new NullPointerException("avatarBy is marked @NonNull but is null");
        }
        this.avatarBy = this.xpathAutoFix ? Xpath.fixIfXpath(avatarBy) : avatarBy;
        this.parentElement = parentElement;
        if (parentElement != null) {
            this.page = parentElement.getPage();
            this.browser = parentElement.getBrowser();
        } else {
            this.page = page;
            this.browser = page != null ? page.getBrowser() : browser;
        }
        this.waiter = this.newDelegateWaiter();
        this.finder = this.newDelegateFinder();
        this.stateResolver = this.newDelegateStateResolver();
        this.actionsStore = new ActionsStore(this, this.newDelegateActionFactory());
        this.actionExecutor = this.newDelegateActionExecutor(this.stateResolver);
        this.elementName = this.getBy().toString();
    }

    protected ElementWaiter newDelegateWaiter() {
        return ElementWaiter.newWaiterS();
    }

    protected Finder newDelegateFinder() {
        return new Finder(this);
    }

    protected ActionFactory newDelegateActionFactory() {
        return new ActionFactory(this);
    }

    protected StateResolver newDelegateStateResolver() {
        return new StateResolver(this);
    }

    protected ActionExecutor newDelegateActionExecutor(StateResolver stateResolver) {
        return new ActionExecutor().withStateResolver(stateResolver);
    }

    public AbstractElement addActionListener(List<ActionListener> actionListener) {
        actionListener.forEach(arg_0 -> ((ActionExecutor)this.actionExecutor).addListener(arg_0));
        return this;
    }

    public AbstractElement addStateListener(List<StateListener> stateListener) {
        stateListener.forEach(arg_0 -> ((StateResolver)this.stateResolver).addListener(arg_0));
        return this;
    }

    public CHILD setName(String elementName) {
        if (!Strings.isEmpty((String)elementName)) {
            this.elementName = elementName;
        }
        return (CHILD)this;
    }

    public CHILD setDescription(String elementDescription) {
        if (!Strings.isEmpty((String)elementDescription)) {
            this.elementDescription = elementDescription;
        }
        return (CHILD)this;
    }

    @Override
    public String getName() {
        return this.elementName;
    }

    @Override
    public By getBy() {
        return this.avatarBy;
    }

    @Override
    public String fullByAsString() {
        return Strings.toString((Object)this.getBy());
    }

    @Override
    public Page getPage() {
        return this.page;
    }

    @Override
    public Optional<InternalElement> getParent() {
        return Optional.ofNullable(this.parentElement);
    }

    @Override
    public ElementWaiter getWaiter() {
        return this.waiter;
    }

    @Override
    public boolean isList() {
        return this.listIndex != -1;
    }

    @Override
    public int getIndex() {
        return this.listIndex;
    }

    @Override
    public InternalElement setIndex(int index) {
        if (!this.isList()) {
            this.getFinder().setFindStrategy(new ListElementStrategy(this));
        }
        this.listIndex = index;
        return this;
    }

    @Override
    public Action<String> getClickAction() {
        return this.actionsStore.clickAction();
    }

    @Override
    public Action<String> getTextAction() {
        return this.actionsStore.textAction();
    }

    @Override
    public Action<?> getClearAction() {
        return this.actionsStore.clear();
    }

    @Override
    public Action<?> getFocusAction() {
        return this.actionsStore.focusAction();
    }

    @Override
    public Action<String> getInputAction(CharSequence ... keys) {
        return this.actionsStore.inputAction(keys);
    }

    public String getTagName() {
        return this.actionExecutor.execute(this.actionsStore.tagName());
    }

    public String getAttribute(String name) {
        return this.actionExecutor.execute(this.actionsStore.attribute(name));
    }

    @Override
    public State jsReady() {
        String js = "return document.readyState";
        return State.of(StateType.OTHER, () -> "complete".equals(Strings.toString((Object)this.getBrowser().actions().executeScript("return document.readyState"))), this.TEAR_DOWN).withName("JS is completed");
    }

    @Override
    public State notExists() {
        this.getFinder().clearCache();
        return State.of(StateType.EXISTS.not(), () -> !this.getFinder().findFast().isSuccess(), this.TEAR_DOWN).withName("Not Exists in DOM").withName("Not Exists Or Not Displayed");
    }

    @Override
    public SetState notDisplayed() {
        return (SetState)SetState.of(StateType.DISPLAYED.not(), this.notExists(), State.of(StateType.SELENIUM_DISPLAYED.not(), webElement -> !webElement.isSuccess() || !((WebElement)webElement.getResult()).isDisplayed(), this.getFinder()).withTearDown(this.TEAR_DOWN)).withName("Not Exists Or Not Displayed");
    }

    @Override
    public SetState notEnabled() {
        return (SetState)SetState.of(StateType.ENABLED.not(), this.notExists(), State.of(StateType.SELENIUM_ENABLED.not(), webElement -> !webElement.isSuccess() || !((WebElement)webElement.getResult()).isEnabled(), this.getFinder()).withTearDown(this.TEAR_DOWN)).withName("Not Exists Or Not Enabled");
    }

    @Override
    public SetState exists() {
        this.getFinder().clearCache();
        if (JS_WAIT) {
            return (SetState)SetState.of(StateType.EXISTS, this.jsReady(), State.of(StateType.SELENIUM_EXISTS, () -> this.getFinder().findFast().isSuccess(), this.TEAR_DOWN)).withTearDown(this.TEAR_DOWN).withName("Exists in DOM");
        }
        return (SetState)SetState.of(StateType.EXISTS, State.of(StateType.SELENIUM_EXISTS, () -> this.getFinder().findFast().isSuccess(), this.TEAR_DOWN)).withTearDown(this.TEAR_DOWN).withName("Exists in DOM");
    }

    @Override
    public SetState displayed() {
        return (SetState)SetState.of(StateType.DISPLAYED, this.exists(), State.of(StateType.SELENIUM_DISPLAYED, () -> {
            WaitResult<WebElement> res = this.getFinder().find();
            return res.isSuccess() && ((WebElement)res.getResult()).isDisplayed();
        }, this.TEAR_DOWN)).withName("Exists And Displayed");
    }

    @Override
    public SetState enabled() {
        return (SetState)SetState.of(StateType.ENABLED, this.exists(), State.of(StateType.SELENIUM_ENABLED, webElement -> webElement.isSuccess() && ((WebElement)webElement.getResult()).isEnabled(), this.getFinder()).withTearDown(this.TEAR_DOWN)).withName("Exists And Enabled");
    }

    @Override
    public SetState ready() {
        return (SetState)SetState.of(StateType.READY, this.displayed(), this.enabled()).withName("Ready to interact");
    }

    @Override
    public SetState clearState() {
        return (SetState)SetState.of(StateType.OTHER, this.exists(), State.of(StateType.OTHER, () -> {
            WaitResult<WebElement> res = this.getFinder().findFast();
            return res.isSuccess() && Strings.isEmpty((String)this.getBrowser().actions().getText((WebElement)res.getResult()));
        }, this.TEAR_DOWN)).withName("Text of the element became an nonArg");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PumpElement(");
        sb.append("type=").append(this.getClass().getSimpleName());
        sb.append(", avatarBy=").append(this.avatarBy);
        if (this.page == null) {
            sb.append(", browser=").append((Object)this.browser.getConfig().getType());
        }
        if (this.parentElement != null) {
            sb.append(", parentElement=").append(this.parentElement.getClass().getSimpleName()).append(":").append(this.parentElement.getBy());
        }
        sb.append(", elementName='").append(this.elementName).append('\'');
        sb.append(", elementDescription='").append(this.elementDescription).append('\'');
        if (this.page != null) {
            sb.append(", page=").append(this.page);
        }
        if (this.isList()) {
            sb.append(", listIndex=").append(this.listIndex);
        }
        sb.append(')');
        return sb.toString();
    }

    public Map<String, String> getInfo() {
        LinkedHashMap result = Maps.newLinkedHashMap();
        result.put("type", this.getClass().getSimpleName());
        if (this.isList()) {
            result.put("list index", String.valueOf(this.getIndex()));
        } else {
            result.put("list element", "no");
        }
        result.put("name", this.getName());
        result.put("description", this.getElementDescription());
        result.put("by", this.getBy().toString());
        if (this.parentElement != null) {
            result.put("parentElement", Strings.space((String[])new String[]{this.parentElement.getName()}));
        } else {
            result.put("parentElement", "no");
        }
        if (this.page != null) {
            result.put("page", Strings.space((String[])new String[]{this.page.getName(), this.page.getUrl()}));
        } else {
            result.put("page", "no");
        }
        result.put("browser", this.getBrowser().getId());
        return result;
    }

    @Override
    public Browser getBrowser() {
        return this.browser;
    }

    @Override
    public ActionExecutor getActionExecutor() {
        return this.actionExecutor;
    }

    @Override
    public StateResolver getStateResolver() {
        return this.stateResolver;
    }

    @Override
    public Finder getFinder() {
        return this.finder;
    }

    @Override
    public ActionsStore getActionsStore() {
        return this.actionsStore;
    }

    protected void setXpathAutoFix(boolean xpathAutoFix) {
        this.xpathAutoFix = xpathAutoFix;
    }

    public String getElementDescription() {
        return this.elementDescription;
    }
}

