/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.elements.internal;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import ru.mk.pump.commons.helpers.Parameters;
import ru.mk.pump.commons.utils.ParameterUtils;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.web.constants.ElementParams;
import ru.mk.pump.web.elements.enums.ActionStrategy;
import ru.mk.pump.web.elements.enums.ClearType;
import ru.mk.pump.web.elements.enums.FocusType;
import ru.mk.pump.web.elements.internal.AbstractElement;
import ru.mk.pump.web.elements.internal.ActionFactory;
import ru.mk.pump.web.elements.internal.State;
import ru.mk.pump.web.elements.internal.interfaces.Action;
import ru.mk.pump.web.elements.internal.interfaces.InternalElement;

public class ActionsStore {
    private final AbstractElement<?> element;
    private final ActionFactory actions;

    ActionsStore(AbstractElement abstractElement, ActionFactory actions) {
        this.element = abstractElement;
        this.actions = actions;
    }

    public Action<Boolean> selected() {
        return this.actions.newAction(WebElement::isSelected, "Is selected").withStrategy(ActionStrategy.SIMPLE, ActionStrategy.NO_STATE_CHECK);
    }

    Action<String> clickAction() {
        return this.actions.newVoidAction(WebElement::click, "Click");
    }

    Action<String> textAction() {
        return this.actions.newAction(webElement -> this.element.getBrowser().actions().getText((WebElement)webElement), "Get text");
    }

    Action clear() {
        return this.actions.newVoidAction((webElement, param) -> {
            ClearType clearType = (ClearType)((Object)((Object)ParameterUtils.getOrDefault((Parameters)param, (String)ElementParams.CLEAR_TYPE.getName(), ClearType.class, (Object)((Object)ClearType.ADVANCED))));
            switch (clearType) {
                case BASIC: {
                    webElement.clear();
                    return;
                }
                case KEYBOARD: {
                    webElement.clear();
                    webElement.sendKeys(new CharSequence[]{Keys.CONTROL, "a"});
                    webElement.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
                    return;
                }
                case ADVANCED: {
                    webElement.clear();
                    State state = this.element.getStateResolver().resolveFast(this.element.clearState());
                    if (state.isResolved() && state.result().isSuccess()) {
                        return;
                    }
                    webElement.sendKeys(new CharSequence[]{Keys.CONTROL, "a"});
                    webElement.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
                    this.element.getStateResolver().resolveFast(this.element.clearState()).result().throwExceptionOnFail();
                    return;
                }
            }
            throw new UnsupportedOperationException("ClearType has been modified. Add new type of ClearType in ActionStore");
        }, "Clear element text");
    }

    Action<String> inputAction(CharSequence ... keysToSend) {
        return this.actions.newAction(webElement -> {
            webElement.sendKeys(keysToSend);
            return this.element.getActionExecutor().execute(this.element.getTextAction().withStrategy(ActionStrategy.SIMPLE));
        }, String.format("Set text '%s'", String.join((CharSequence)"_", keysToSend)));
    }

    Action focusAction() {
        String SCROLL_TOP = "arguments[0].scrollIntoView(true);";
        String SCROLL_BOTTOM = "arguments[0].scrollIntoView(false);";
        String SCROLL_CENTER = "var viewPortHeight = Math.max(document.documentElement.clientHeight, window.innerHeight || 0);var elementTop = arguments[0].getBoundingClientRect().top;window.scrollBy(0, elementTop-(viewPortHeight/2));";
        return this.actions.newVoidAction((webElement, param) -> {
            String scrollScript = "arguments[0].scrollIntoView(true);";
            if (param.has(ElementParams.FOCUS_CUSTOM_SCRIPT.getName())) {
                scrollScript = param.get(ElementParams.FOCUS_CUSTOM_SCRIPT.getName()).getStringValue();
            } else if (param.has(ElementParams.FOCUS_TYPE.getName())) {
                FocusType focusType = (FocusType)((Object)((Object)param.get(ElementParams.FOCUS_TYPE.getName()).getValue(FocusType.class)));
                switch (focusType) {
                    case BOTTOM: {
                        scrollScript = "arguments[0].scrollIntoView(false);";
                        break;
                    }
                    case TOP: {
                        scrollScript = "arguments[0].scrollIntoView(true);";
                        break;
                    }
                    case CENTER: {
                        scrollScript = "var viewPortHeight = Math.max(document.documentElement.clientHeight, window.innerHeight || 0);var elementTop = arguments[0].getBoundingClientRect().top;window.scrollBy(0, elementTop-(viewPortHeight/2));";
                        break;
                    }
                    default: {
                        scrollScript = "arguments[0].scrollIntoView(true);";
                    }
                }
            }
            if (!Strings.isEmpty((String)scrollScript)) {
                this.element.getBrowser().actions().executeScript(scrollScript, webElement);
            }
        }, "Focus on element");
    }

    Action<Boolean> tryClick() {
        return this.actions.newAction(element -> {
            try {
                element.click();
                return true;
            }
            catch (Exception ignore) {
                return false;
            }
        }, "Is clickable");
    }

    Action<String> tagName() {
        return this.actions.newAction(WebElement::getTagName, "Get Attribute").withStrategy(ActionStrategy.SIMPLE).redefineExpectedState(this.element.exists());
    }

    Action<String> attribute(String name) {
        return this.actions.newAction(e -> e.getAttribute(name), "Get Attribute").withStrategy(ActionStrategy.NO_FINALLY, ActionStrategy.NO_AFTER).redefineExpectedState(this.element.exists());
    }

    <T extends InternalElement> Action<List<T>> subItemsAction(By by, Class<T> elementClass) {
        return null;
    }

    <T extends InternalElement> Action subItemAction(By by, Class<T> elementClass) {
        return null;
    }
}

