/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.elements.internal;

import java.util.Map;
import javax.annotation.Nullable;
import org.openqa.selenium.By;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.helpers.Parameters;
import ru.mk.pump.commons.reporter.Reporter;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.commons.utils.Verifier;
import ru.mk.pump.web.browsers.Browser;
import ru.mk.pump.web.common.api.PageItemImplDispatcher;
import ru.mk.pump.web.common.pageobject.Initializer;
import ru.mk.pump.web.elements.ElementFactory;
import ru.mk.pump.web.elements.ElementImplDispatcher;
import ru.mk.pump.web.elements.api.Element;
import ru.mk.pump.web.elements.enums.ActionStrategy;
import ru.mk.pump.web.elements.internal.AbstractElement;
import ru.mk.pump.web.elements.internal.ActionExecutor;
import ru.mk.pump.web.elements.internal.BaseElementHelper;
import ru.mk.pump.web.elements.internal.State;
import ru.mk.pump.web.elements.internal.StateResolver;
import ru.mk.pump.web.elements.internal.SubElementHelper;
import ru.mk.pump.web.elements.internal.interfaces.ElementInfo;
import ru.mk.pump.web.elements.internal.interfaces.InternalElement;
import ru.mk.pump.web.page.api.Page;
import ru.mk.pump.web.utils.WebReporter;

public class BaseElement
extends AbstractElement<BaseElement>
implements Element {
    private static final Logger log = LoggerFactory.getLogger(BaseElement.class);
    private final Parameters elementParams = Parameters.of();
    private ElementFactory selfElementFactory;
    private Reporter reporter;
    private Verifier verifier;
    private Initializer initializer;
    private BaseElementHelper helper;

    public BaseElement(By avatarBy, Page page) {
        super(avatarBy, page);
        this.initLocal();
    }

    public BaseElement(By avatarBy, InternalElement parentElement) {
        super(avatarBy, parentElement);
        this.initLocal();
    }

    public BaseElement(By avatarBy, Browser browser) {
        super(avatarBy, browser);
        this.initLocal();
    }

    public Parameters getParams() {
        return this.elementParams;
    }

    public BaseElement withParams(Parameters elementConfig) {
        this.elementParams.addAll(elementConfig);
        this.initFromParams();
        this.getActionExecutor().withParameters(elementConfig);
        return this;
    }

    @Override
    public boolean tryClick() {
        return this.getActionExecutor().execute(this.getActionsStore().tryClick());
    }

    public BaseElement withVerifier(@Nullable Verifier verifier) {
        if (verifier != null) {
            this.verifier = verifier;
        }
        return this;
    }

    public BaseElement setReporter(@Nullable Reporter reporter) {
        if (reporter != null) {
            this.reporter = reporter;
        }
        return this;
    }

    @Override
    public String getText() {
        return (String)this.getActionExecutor().execute(this.getTextAction());
    }

    @Override
    public void clear() {
        this.getActionExecutor().execute(this.getClearAction());
    }

    @Override
    public String getTextHidden() {
        return (String)this.getActionExecutor().execute(this.getTextAction().withStrategy(ActionStrategy.SIMPLE).redefineExpectedState(this.exists()));
    }

    @Override
    public void click() {
        this.getActionExecutor().execute(this.getClickAction());
    }

    @Override
    public ElementInfo info() {
        return this;
    }

    @Override
    public InternalElement advanced() {
        return this;
    }

    @Override
    public State isDisplayed() {
        return this.getStateResolver().resolve(this.displayed());
    }

    @Override
    public State isNotDisplayed() {
        return this.getStateResolver().resolve(this.notDisplayed());
    }

    @Override
    public State isExists() {
        return this.getStateResolver().resolve(this.exists());
    }

    @Override
    public State isNotExists() {
        return this.getStateResolver().resolve(this.notExists());
    }

    @Override
    public State isEnabled() {
        return this.getStateResolver().resolve(this.enabled());
    }

    @Override
    public State isNotEnabled() {
        return this.getStateResolver().resolve(this.notEnabled());
    }

    @Override
    public State isDisplayed(int timeoutMs) {
        return this.getStateResolver().resolve((State)this.displayed(), timeoutMs);
    }

    @Override
    public State isNotDisplayed(int timeoutMs) {
        return this.getStateResolver().resolve((State)this.notDisplayed(), timeoutMs);
    }

    @Override
    public State isExists(int timeoutMs) {
        return this.getStateResolver().resolve((State)this.exists(), timeoutMs);
    }

    @Override
    public State isNotExists(int timeoutMs) {
        return this.getStateResolver().resolve(this.notExists(), timeoutMs);
    }

    @Override
    public <T extends Element> SubElementHelper<T> getSubElements(Class<T> subElementClazz) {
        return new SubElementHelper<T>(subElementClazz, this, this.getSubElementFactory());
    }

    public boolean isJsReady() {
        State res = this.getStateResolver().resolve(this.jsReady());
        return res.result().isSuccess();
    }

    public String toPrettyString() {
        return Strings.toPrettyString(this.getInfo());
    }

    public BaseElement setSelfFactory(ElementFactory selfElementFactory) {
        this.selfElementFactory = selfElementFactory;
        return this;
    }

    @Override
    public String getDescription() {
        return super.getElementDescription();
    }

    protected void initFromParams() {
    }

    @Override
    protected ActionExecutor newDelegateActionExecutor(StateResolver stateResolver) {
        return super.newDelegateActionExecutor(stateResolver).addBefore(this.getFocusAction());
    }

    @Override
    public BaseElement setIndex(int index) {
        super.setIndex(index);
        return this;
    }

    @Override
    public Map<String, String> getInfo() {
        Map<String, String> res = super.getInfo();
        res.put("element parameters", Strings.toPrettyString((Object)this.getParams()));
        return res;
    }

    protected ElementFactory getSubElementFactory() {
        if (this.selfElementFactory == null) {
            this.selfElementFactory = this.getPage() != null ? new ElementFactory((PageItemImplDispatcher)new ElementImplDispatcher(), this.getPage()) : new ElementFactory((PageItemImplDispatcher)new ElementImplDispatcher(), this.getBrowser());
        }
        return this.selfElementFactory;
    }

    private void initLocal() {
        this.setReporter(WebReporter.getReporter());
        this.withVerifier(WebReporter.getVerifier());
        this.helper = new BaseElementHelper(this);
        this.helper.windowSizeCheckerEnable();
        this.helper.stateReportingEnable();
        this.helper.actionsReportingEnable();
    }

    protected Reporter getReporter() {
        return this.reporter;
    }

    protected Verifier getVerifier() {
        return this.verifier;
    }
}

