/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.elements.internal;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import lombok.NonNull;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.utils.WaitResult;
import ru.mk.pump.commons.utils.Waiter;
import ru.mk.pump.web.configuration.ConfigurationHolder;

public class ElementWaiter {
    private static final Logger log = LoggerFactory.getLogger(ElementWaiter.class);
    public static int DEFAULT_TIMEOUT_S = ConfigurationHolder.get().getElement().getStateTimeout();
    public static int DEFAULT_DELAY_MS = ConfigurationHolder.get().getElement().getStateDelay();
    private final int timeout;
    private Waiter waiter;
    private int delayMs;

    private ElementWaiter(int timeout, int delayMs, Waiter waiter) {
        this.timeout = timeout;
        this.delayMs = DEFAULT_DELAY_MS;
        this.waiter = waiter;
    }

    private ElementWaiter(int timeout, int delayMs, TimeUnit timeoutUnit) {
        this(timeout, delayMs, new Waiter().withTimeoutUnit(timeoutUnit));
    }

    private ElementWaiter(int timeout, int delayMs) {
        this(timeout, delayMs, TimeUnit.SECONDS);
    }

    private ElementWaiter() {
        this(DEFAULT_TIMEOUT_S, DEFAULT_DELAY_MS);
    }

    public static ElementWaiter newWaiterMs(int timeoutMs) {
        return new ElementWaiter(timeoutMs, 0, TimeUnit.MILLISECONDS);
    }

    public static ElementWaiter newWaiterS(int timeoutMs) {
        return new ElementWaiter(timeoutMs, 0);
    }

    public static ElementWaiter newWaiterS() {
        return new ElementWaiter();
    }

    public ElementWaiter clear() {
        this.waiter.clear();
        return this;
    }

    public ElementWaiter setReThrow(boolean reThrow) {
        this.waiter.withReThrow(reThrow);
        return this;
    }

    public ElementWaiter withTimeoutMs(int timeoutMs) {
        return new ElementWaiter(timeoutMs, this.delayMs, TimeUnit.MILLISECONDS);
    }

    public ElementWaiter withTimeoutS(int timeoutS) {
        return new ElementWaiter(timeoutS, this.delayMs, TimeUnit.SECONDS);
    }

    public ElementWaiter withTimeoutUnit(TimeUnit timeoutUnit) {
        return new ElementWaiter(this.timeout, this.delayMs, timeoutUnit);
    }

    public ElementWaiter withDelay(int delayMs) {
        return new ElementWaiter(this.timeout, delayMs, this.waiter);
    }

    public ElementWaiter setNotIgnoreExceptions(@NonNull Class<? extends Throwable> notIgnoringThrowable) {
        if (notIgnoringThrowable == null) {
            throw new NullPointerException("notIgnoringThrowable is marked @NonNull but is null");
        }
        this.waiter.withNotIgnoreExceptions(notIgnoringThrowable);
        return this;
    }

    public static <T> VariabilityMatcher<T> newVariabilityMatcher(BiPredicate<T, T> prevMatchPredicate) {
        return new VariabilityMatcher<T>(prevMatchPredicate);
    }

    public <T> WaitResult<T> waitPredicate(Callable<T> supplier, BiPredicate<T, T> prevMatchPredicate) {
        return this.waiter.waitIgnoreExceptions(this.timeout, this.delayMs, supplier, ElementWaiter.newVariabilityMatcher(prevMatchPredicate));
    }

    public <T> WaitResult<T> wait(Callable<T> supplier, Matcher<T> matcher) {
        return this.waiter.waitIgnoreExceptions(this.timeout, this.delayMs, supplier, matcher);
    }

    public WaitResult<Boolean> wait(Callable<Boolean> supplier) {
        return this.waiter.waitIgnoreExceptions(this.timeout, this.delayMs, supplier);
    }

    public int getTimeout() {
        return this.timeout;
    }

    static class VariabilityMatcher<T>
    extends BaseMatcher<T> {
        private volatile Object prevItem;
        private final BiPredicate<T, T> prevMatchPredicate;

        VariabilityMatcher(BiPredicate<T, T> prevMatchPredicate) {
            this.prevMatchPredicate = prevMatchPredicate;
        }

        public boolean matches(Object item) {
            boolean res = this.prevItem != null && this.prevMatchPredicate.test(this.prevItem, item);
            this.prevItem = item;
            return res;
        }

        public void describeTo(Description description) {
        }
    }
}

