/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.elements.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.commons.utils.WaitResult;
import ru.mk.pump.web.elements.ElementConfig;
import ru.mk.pump.web.elements.ElementFactory;
import ru.mk.pump.web.elements.api.Element;
import ru.mk.pump.web.elements.internal.BaseElement;
import ru.mk.pump.web.elements.internal.interfaces.InternalElement;
import ru.mk.pump.web.exceptions.ElementException;
import ru.mk.pump.web.exceptions.ElementFinderNotFoundException;
import ru.mk.pump.web.utils.Xpath;

public class SubElementHelper<T extends Element> {
    private static final Logger log = LoggerFactory.getLogger(SubElementHelper.class);
    public static final int DEFAULT_TRY_COUNT = 2;
    private int tryCount = 2;
    private final Class<T> subElementClass;
    private final BaseElement parent;
    private final ElementFactory elementFactory;
    private final ElementConfig elementConfig;

    protected SubElementHelper(Class<T> subElementClass, BaseElement parent, ElementFactory elementFactory) {
        this(subElementClass, parent, elementFactory, ElementConfig.of(Strings.space((String[])new String[]{"sub-element of", parent.getName()}), Strings.space((String[])new String[]{"sub-element of", parent.getDescription()})));
    }

    protected SubElementHelper(Class<T> subElementClass, BaseElement parent, ElementFactory elementFactory, ElementConfig elementConfig) {
        this.subElementClass = subElementClass;
        this.parent = parent;
        this.elementFactory = elementFactory;
        this.elementConfig = elementConfig;
    }

    public SubElementHelper<T> newWithElementConfig(ElementConfig elementConfig) {
        return new SubElementHelper<T>(this.subElementClass, this.parent, this.elementFactory, elementConfig);
    }

    public T find(By ... bys) {
        if (bys == null) {
            throw new NullPointerException("bys is marked @NonNull but is null");
        }
        List<T> list = this.findList(bys);
        if (list.isEmpty()) {
            throw this.exceptionNoExistsSub(Arrays.toString(bys));
        }
        return (T)((Element)list.get(0));
    }

    public List<T> findList(@NonNull Predicate<List<WebElement>> webElementListPredicate, By ... bys) {
        if (webElementListPredicate == null) {
            throw new NullPointerException("webElementListPredicate is marked @NonNull but is null");
        }
        if (bys == null) {
            throw new NullPointerException("bys is marked @NonNull but is null");
        }
        if (bys.length == 0) {
            return Collections.emptyList();
        }
        for (By currentBy : bys) {
            this.parent.getStateResolver().resolve(this.parent.jsReady()).result().throwExceptionOnFail(r -> this.exceptionNoExists((WaitResult<?>)r, currentBy.toString()));
            this.parent.getStateResolver().resolve(this.parent.exists()).result().throwExceptionOnFail(r -> this.exceptionNoExists((WaitResult<?>)r, currentBy.toString()));
            WebElement sourceWebElement = (WebElement)this.parent.getFinder().findFast().throwExceptionOnFail(r -> this.exceptionNoExists((WaitResult<?>)r, currentBy.toString())).getResult();
            List elements = sourceWebElement.findElements(Xpath.fixIfXpath(currentBy));
            if (!webElementListPredicate.test(elements)) continue;
            return IntStream.range(0, elements.size()).boxed().map(index -> {
                T newElement = this.elementFactory.newElement(this.subElementClass, Xpath.fixIfXpath(currentBy), this.parent, this.elementConfig);
                ((InternalElement)newElement).setIndex((int)index);
                return newElement;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<T> findList(By ... bys) {
        if (bys == null) {
            throw new NullPointerException("bys is marked @NonNull but is null");
        }
        int tryLocal = 0;
        while (this.tryCount >= tryLocal++) {
            List<T> res = this.findList((List<WebElement> els) -> !els.isEmpty(), bys);
            if (res.isEmpty()) continue;
            log.debug("[SUB-ELEMENTS] findList try count {}", (Object)tryLocal);
            return res;
        }
        log.debug("[SUB-ELEMENTS] findList try count {}", (Object)tryLocal);
        return Collections.emptyList();
    }

    public List<T> findListXpathAdvanced(@Nullable String xpathString, @Nullable Predicate<WebElement> webElementPredicate, String ... postfixXpaths) {
        int tryLocal = 0;
        Pair<Integer, By> context = this.findXpath(xpathString, webElementPredicate, false, postfixXpaths);
        while (this.tryCount >= tryLocal++ && (Integer)context.getKey() <= 0) {
            log.trace("[SUB-ELEMENTS] findXpathAdvanced try number {}", (Object)tryLocal);
            context = this.findXpath(xpathString, webElementPredicate, true, postfixXpaths);
        }
        log.debug("[SUB-ELEMENTS] findListXpathAdvanced try count {}", (Object)tryLocal);
        if ((Integer)context.getKey() < 1) {
            return Collections.emptyList();
        }
        By finalBy = (By)context.getValue();
        return IntStream.range(0, (Integer)context.getKey()).boxed().map(index -> {
            T newElement = this.elementFactory.newElement(this.subElementClass, finalBy, this.parent, this.elementConfig);
            ((InternalElement)newElement).setIndex((int)index);
            return newElement;
        }).collect(Collectors.toList());
    }

    public T findXpathAdvanced(@Nullable String xpathString, @Nullable Predicate<WebElement> webElementPredicate, String ... postfixXpaths) {
        int tryLocal = 0;
        Pair<Integer, By> context = this.findXpath(xpathString, webElementPredicate, true, postfixXpaths);
        while (this.tryCount >= tryLocal++ && (Integer)context.getKey() <= 0) {
            log.trace("[SUB-ELEMENTS] findXpathAdvanced try number {}", (Object)tryLocal);
            context = this.findXpath(xpathString, webElementPredicate, true, postfixXpaths);
        }
        log.debug("[SUB-ELEMENTS] findXpathAdvanced try count {}", (Object)tryLocal);
        if ((Integer)context.getKey() < 1) {
            throw this.exceptionNoExistsSub(xpathString + " " + Strings.toString((Object)postfixXpaths));
        }
        return this.elementFactory.newElement(this.subElementClass, (By)context.getValue(), this.parent, this.elementConfig);
    }

    private Pair<Integer, By> findXpath(String xpathString, Predicate<WebElement> webElementAttributePredicate, boolean one, String ... postfixXpaths) {
        if (webElementAttributePredicate == null) {
            webElementAttributePredicate = el -> true;
        }
        String xpathFinal = Xpath.fixXpath(xpathString);
        By byResult = By.xpath((String)xpathFinal);
        this.parent.getStateResolver().resolve(this.parent.jsReady()).result().throwExceptionOnFail(r -> this.exceptionNoExists((WaitResult<?>)r, "xpath: " + xpathString));
        log.debug("[SUB-ELEMENTS] Parent element is jsReady");
        this.parent.getStateResolver().resolve(this.parent.exists()).result().throwExceptionOnFail(r -> this.exceptionNoExists((WaitResult<?>)r, "xpath: " + xpathString));
        log.debug("[SUB-ELEMENTS] Parent element is exists");
        WebElement sourceWebElement = (WebElement)this.parent.getFinder().findFast().throwExceptionOnFail(r -> this.exceptionNoExists((WaitResult<?>)r, "xpath: " + xpathString)).getResult();
        Iterator<Object> iterator = postfixXpaths == null ? Collections.emptyIterator() : Arrays.asList(postfixXpaths).iterator();
        List elements = sourceWebElement.findElements(byResult);
        while (iterator.hasNext() && this.checkPredicate(elements, webElementAttributePredicate, one)) {
            byResult = By.xpath((String)Xpath.concat(xpathFinal, (String)iterator.next()));
            elements = sourceWebElement.findElements(byResult);
        }
        return Pair.of((Object)sourceWebElement.findElements(byResult).size(), (Object)byResult);
    }

    private boolean checkPredicate(List<WebElement> webElements, Predicate<WebElement> webElementAttributePredicate, boolean one) {
        if (one) {
            return webElements.isEmpty() || !webElementAttributePredicate.test(webElements.get(0));
        }
        return webElements.isEmpty() || !webElements.stream().allMatch(webElementAttributePredicate);
    }

    private ElementException exceptionNoExists(WaitResult<?> res, String byString) {
        return new ElementFinderNotFoundException(String.format("Cannot find sub rules '%s' by '%s' because parent is not exists", this.subElementClass.getSimpleName(), this.logPath(byString)), res.getCause()).withTargetElement(this.parent);
    }

    private ElementException exceptionNoExistsSub(String byString) {
        return new ElementFinderNotFoundException(String.format("Cannot find any sub rules '%s' by '%s' ", this.subElementClass.getSimpleName(), this.logPath(byString))).withTargetElement(this.parent);
    }

    private String logPath(String byString) {
        return "parent[" + this.parent.getBy().toString() + "] " + byString;
    }

    public void setTryCount(int tryCount) {
        this.tryCount = tryCount;
    }
}

