/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.elements.internal.impl;

import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.helpers.Parameter;
import ru.mk.pump.commons.helpers.Parameters;
import ru.mk.pump.commons.utils.ParameterUtils;
import ru.mk.pump.commons.utils.Preconditions;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.web.browsers.Browser;
import ru.mk.pump.web.constants.ElementParams;
import ru.mk.pump.web.elements.api.Element;
import ru.mk.pump.web.elements.api.part.SelectedItems;
import ru.mk.pump.web.elements.enums.ActionStrategy;
import ru.mk.pump.web.elements.enums.SelectedStrategy;
import ru.mk.pump.web.elements.enums.StateType;
import ru.mk.pump.web.elements.internal.ActionFactory;
import ru.mk.pump.web.elements.internal.DocParameters;
import ru.mk.pump.web.elements.internal.SetState;
import ru.mk.pump.web.elements.internal.State;
import ru.mk.pump.web.elements.internal.impl.AbstractWithItems;
import ru.mk.pump.web.elements.internal.interfaces.Action;
import ru.mk.pump.web.elements.internal.interfaces.InternalElement;
import ru.mk.pump.web.exceptions.SubElementsNotFoundException;
import ru.mk.pump.web.page.api.Page;

@DocParameters(value={"SELECTED_MARK", "SELECTED_STRATEGY"})
public abstract class AbstractSelectorItems
extends AbstractWithItems
implements SelectedItems {
    private static final Logger log = LoggerFactory.getLogger(AbstractSelectorItems.class);
    private static final String DEFAULT_SELECTED = "selected";
    private static final By[] DEFAULT_ITEMS_BY = new By[]{By.xpath((String)"//option"), By.xpath((String)"//div[contains(@class,'option') and not(contains(@class,'options'))]"), By.xpath((String)"//div[contains(@class,'item') and not(contains(@class,'items'))]")};
    private final ActionFactory actionFactory = this.newDelegateActionFactory();
    private String selectedCondition = "selected";
    private SelectedStrategy selectedStrategy = SelectedStrategy.CONTAINS;

    public AbstractSelectorItems(By avatarBy, Page page) {
        super(avatarBy, page);
        this.setItemsBy(DEFAULT_ITEMS_BY);
    }

    public AbstractSelectorItems(By avatarBy, InternalElement parentElement) {
        super(avatarBy, parentElement);
        this.setItemsBy(DEFAULT_ITEMS_BY);
    }

    public AbstractSelectorItems(By avatarBy, Browser browser) {
        super(avatarBy, browser);
        this.setItemsBy(DEFAULT_ITEMS_BY);
    }

    @Override
    public SetState ready() {
        return SetState.of(StateType.READY, super.ready(), State.of(StateType.OTHER, () -> this.isNotEnoughChanging(CHANGING_TIMEOUT)).withName("Items are not changing enough"));
    }

    @Override
    public void set(Parameters params) {
        if (params.has(ElementParams.EDITABLE_SET_STRING)) {
            this.select((String)ParameterUtils.getOrNull((Parameters)params, (String)ElementParams.EDITABLE_SET_STRING.getName(), String.class));
            return;
        }
        if (params.has(ElementParams.EDITABLE_SET_NUMBER)) {
            this.select((Integer)ParameterUtils.getOrNull((Parameters)params, (String)ElementParams.EDITABLE_SET_NUMBER.getName(), Integer.class));
            return;
        }
        throw new IllegalArgumentException(String.format("Params map '%s' does not contains '%s'", Strings.toString((Object)params), Strings.concat((CharSequence)ElementParams.EDITABLE_SET_NUMBER.getName(), (String[])new String[]{ElementParams.EDITABLE_SET_STRING.getName()})));
    }

    @Override
    public void select(String itemText) {
        String finalText = itemText == null ? "" : itemText;
        List<Element> elements = this.getItems();
        Action action = this.actionFactory.newVoidAction(webElement -> elements.stream().filter(element -> this.find((Element)element, finalText)).findFirst().orElseThrow(() -> new SubElementsNotFoundException("text name = " + itemText).withTargetElement(this)).click(), "Select item by text " + itemText).withStrategy(ActionStrategy.NO_AFTER, ActionStrategy.NO_FINALLY, ActionStrategy.NO_STATE_CHECK);
        this.getActionExecutor().execute(action);
    }

    @Override
    public void select(int index) {
        List<Element> elements = this.getItems();
        Preconditions.checkArgListSize((int)index, elements);
        Action action = this.actionFactory.newVoidAction(w -> ((Element)elements.get(index)).click(), "Select item by index " + index).withStrategy(ActionStrategy.NO_AFTER, ActionStrategy.NO_FINALLY, ActionStrategy.NO_STATE_CHECK);
        this.getActionExecutor().execute(action);
    }

    @Override
    public Element getSelected() {
        return this.getItems().stream().filter(i -> StringUtils.contains((CharSequence)i.getAttribute("class"), (CharSequence)this.selectedCondition)).findFirst().orElseThrow(() -> new SubElementsNotFoundException("selected element class contains : " + this.selectedCondition).withTargetElement(this));
    }

    @Override
    public String getItemsTextFast() {
        this.refreshItemsCache();
        List<Element> items = this.getItemsCache();
        if (items.isEmpty()) {
            return "";
        }
        String res = items.get(0).getSubElements(Element.class).find(By.xpath((String)"/../")).getTextHidden();
        return res;
    }

    @Override
    protected void initFromParams() {
        super.initFromParams();
        this.selectedCondition = (String)ParameterUtils.getOrDefault((Parameters)this.getParams(), (String)ElementParams.SELECTED_MARK.getName(), Parameter::getStringValue, (Object)this.selectedCondition);
        this.selectedStrategy = (SelectedStrategy)((Object)ParameterUtils.getOrDefault((Parameters)this.getParams(), (String)ElementParams.SELECTED_STRATEGY.getName(), SelectedStrategy.class, (Object)((Object)this.selectedStrategy)));
    }

    protected boolean find(Element element, @NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked @NonNull but is null");
        }
        String elText = element.getTextHidden();
        if (this.selectedStrategy == SelectedStrategy.CONTAINS) {
            return StringUtils.containsIgnoreCase((CharSequence)elText, (CharSequence)text);
        }
        if (this.selectedStrategy == SelectedStrategy.EQUALS) {
            return text.equals(elText);
        }
        throw new UnsupportedOperationException("Strategy not support " + this.selectedStrategy.toString());
    }

    public ActionFactory getActionFactory() {
        return this.actionFactory;
    }

    protected String getSelectedCondition() {
        return this.selectedCondition;
    }

    protected SelectedStrategy getSelectedStrategy() {
        return this.selectedStrategy;
    }
}

