/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.exceptions;

import ru.mk.pump.commons.exception.PumpMessage;
import ru.mk.pump.commons.interfaces.StrictInfo;
import ru.mk.pump.web.elements.internal.interfaces.Action;
import ru.mk.pump.web.elements.internal.interfaces.InternalElement;
import ru.mk.pump.web.exceptions.AbstractWebException;

public class ElementException
extends AbstractWebException {
    static final String ELEMENT = "element";
    private static final String TITLE = "Pump element '%s' error";

    public ElementException(String title) {
        super(title);
    }

    public ElementException(String title, Throwable cause) {
        super(title, cause);
    }

    public ElementException(PumpMessage exceptionMessage) {
        super(exceptionMessage);
    }

    public ElementException(PumpMessage exceptionMessage, Throwable cause) {
        super(exceptionMessage, cause);
    }

    private static PumpMessage message(Action action) {
        return new PumpMessage(String.format(TITLE, action.name())).addExtraInfo((StrictInfo)action);
    }

    public ElementException withTargetElement(InternalElement element) {
        this.addTarget(ELEMENT, element);
        this.withBrowser(element.getBrowser());
        this.withPage(element.getPage());
        return this;
    }

    ElementException withElement(InternalElement element) {
        this.addEnv(ELEMENT, element);
        this.withBrowser(element.getBrowser());
        this.withPage(element.getPage());
        return this;
    }
}

