/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.exceptions;

import ru.mk.pump.commons.exception.PumpMessage;
import ru.mk.pump.web.elements.ElementFactory;
import ru.mk.pump.web.elements.internal.interfaces.InternalElement;
import ru.mk.pump.web.exceptions.AbstractWebException;

public class ElementFactoryException
extends AbstractWebException {
    static final String PARENT = "parent_element";
    static final String FACTORY = "element_factory";

    public ElementFactoryException(String message) {
        super(message);
    }

    public ElementFactoryException(PumpMessage exceptionMessage) {
        super(exceptionMessage);
    }

    public ElementFactoryException(PumpMessage exceptionMessage, Throwable cause) {
        super(exceptionMessage, cause);
    }

    public ElementFactoryException(String message, Throwable cause) {
        super(message, cause);
    }

    public ElementFactoryException withTargetFactory(ElementFactory elementFactory) {
        this.addTarget(FACTORY, elementFactory);
        this.addTarget("element_dispatcher", elementFactory.getElementImplDispatcher());
        this.withBrowser(elementFactory.getBrowser());
        this.withPage(elementFactory.getPage());
        return this;
    }

    public ElementFactoryException withTargetParent(InternalElement element) {
        this.addTarget(PARENT, element);
        return this;
    }

    ElementFactoryException withFactory(ElementFactory elementFactory) {
        this.addEnv(FACTORY, elementFactory);
        this.addEnv("element_dispatcher", elementFactory.getElementImplDispatcher());
        this.withBrowser(elementFactory.getBrowser());
        this.withPage(elementFactory.getPage());
        return this;
    }
}

