/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.interpretator.rules;

import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.utils.Walker;
import ru.mk.pump.web.interpretator.rules.Rule;

public final class Accumulator {
    private static final Logger log = LoggerFactory.getLogger(Accumulator.class);
    private final Rule rule;
    private final Walker walker;
    private final StringBuilder result = new StringBuilder();

    public Accumulator(Rule rule, Walker walker) {
        this.rule = rule;
        this.walker = walker;
    }

    public boolean next() {
        if (!this.rule.parseEnd(this.walker.getLeft(), this.walker.getRight()) || this.result.length() < this.rule.minSize()) {
            this.result.append(this.walker.next());
            return true;
        }
        if (this.result.length() == 0) {
            this.walker.next();
        }
        return false;
    }

    public String getResult() {
        return this.result.toString();
    }

    public static Optional<Accumulator> newAccumulator(Walker walker, Set<Rule> ruleSet) {
        Optional<Rule> ruleOptional = ruleSet.stream().filter(r -> r.parseStart(walker.getLeft(), walker.getRight())).findFirst();
        return ruleOptional.map(rule1 -> new Accumulator((Rule)rule1, walker));
    }

    public String toString() {
        return "Accumulator(rule=" + this.getRule() + ", walker=" + this.walker + ", result=" + this.getResult() + ")";
    }

    public Rule getRule() {
        return this.rule;
    }
}

