/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.interpretator.rules;

import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.utils.Walker;
import ru.mk.pump.web.interpretator.rules.Accumulator;
import ru.mk.pump.web.interpretator.rules.Rule;

final class PumpkinParser {
    private static final Logger log = LoggerFactory.getLogger(PumpkinParser.class);
    private final Set<Rule> rules;
    private final String expression;
    private Walker walker;
    private Accumulator accumulator;

    PumpkinParser(String expression, Set<Rule> rules) {
        this.expression = expression;
        this.walker = new Walker(expression);
        this.rules = rules;
    }

    Optional<Accumulator> parseNext() {
        Optional<Accumulator> accumulatorOptional = Accumulator.newAccumulator(this.walker, this.rules);
        if (accumulatorOptional.isPresent()) {
            this.accumulator = accumulatorOptional.get();
            while (this.accumulator.next()) {
            }
            log.debug("Parsed success '{}' , '{}'", (Object)this.accumulator.getResult(), (Object)this.accumulator.getRule().getClass().getSimpleName());
        } else {
            log.debug("Non parsed '{}'", (Object)this.walker.getRight());
            if (this.walker.hasNext()) {
                this.walker.next();
            } else {
                log.debug("Source is empty '{}'", (Object)this.walker);
            }
        }
        return accumulatorOptional;
    }

    boolean isCompleted() {
        return !this.walker.hasNext();
    }

    public String getExpression() {
        return this.expression;
    }

    public Walker getWalker() {
        return this.walker;
    }

    public Accumulator getAccumulator() {
        return this.accumulator;
    }
}

