/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.page;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import ru.mk.pump.commons.utils.CallableExt;
import ru.mk.pump.commons.utils.Verifier;
import ru.mk.pump.web.elements.api.Element;
import ru.mk.pump.web.elements.internal.ElementWaiter;
import ru.mk.pump.web.page.api.Page;
import ru.mk.pump.web.page.api.PageLoader;

public class PageLoaderPump
implements PageLoader {
    private final Page page;
    private ElementWaiter waiter;
    private Verifier checker;
    private Set<Element> existsElements = Sets.newHashSet();
    private Set<Element> displayedElements = Sets.newHashSet();
    private Map<Element, String> textContainsElements = Maps.newHashMap();
    private Map<Element, Predicate<Element>> predicateElements = Maps.newHashMap();
    private Set<CallableExt<Boolean>> conditions = Sets.newHashSet();

    public PageLoaderPump(Page page, Verifier checker) {
        this.page = page;
        this.checker = checker;
    }

    @Override
    public Page getPage() {
        return this.page;
    }

    @Override
    public ElementWaiter getWaiter() {
        if (this.waiter == null) {
            this.waiter = ElementWaiter.newWaiterS(10);
        }
        return this.waiter;
    }

    @Override
    public void addExistsElements(Element ... elements) {
        this.existsElements.addAll(Arrays.asList(elements));
    }

    @Override
    public void addDisplayedElements(Element ... elements) {
        this.displayedElements.addAll(Arrays.asList(elements));
    }

    @Override
    public void addTextContainsElement(Element element, String text) {
        this.textContainsElements.put(element, text);
    }

    @Override
    public void addPredicateElement(Element element, Predicate<Element> thisElementPredicate) {
        this.predicateElements.put(element, thisElementPredicate);
    }

    @Override
    public void addAdditionalCondition(CallableExt<Boolean> booleanCallable) {
        this.conditions.add(booleanCallable);
    }

    @Override
    public void checkElements() {
        this.existsElements.forEach(el -> this.checker.checkTrue(String.format("On page '%s' element '%s' is exists", this.getPage().getName(), el.info().getName()), el.isExists().result().isSuccess(), new String[0]));
        this.displayedElements.forEach(el -> this.checker.checkTrue(String.format("On page '%s' element '%s' is displayed", this.getPage().getName(), el.info().getName()), el.isDisplayed().result().isSuccess(), new String[0]));
        this.textContainsElements.forEach((el, text) -> this.checker.contains(String.format("On page '%s' element '%s' contains text", this.getPage().getName(), el.info().getName()), text, el.getTextHidden(), new String[0]));
        this.predicateElements.forEach((el, predicate) -> this.checker.checkTrue(String.format("On page '%s' predicate element '%s' is success", this.getPage().getName(), el.info().getName()), predicate.test(el), new String[0]));
    }

    @Override
    public void checkAdditionalCondition() {
        this.conditions.forEach(call -> this.checker.noExceptions(String.format(call.getDescription() + " Page is '%s'", this.getPage().getName()), () -> this.getWaiter().wait((Callable<Boolean>)call).throwExceptionOnFail()));
    }

    @Override
    public void checkUrl() {
        ElementWaiter.newWaiterS().wait(() -> StringUtils.containsIgnoreCase((CharSequence)this.getPage().getBrowser().actions().getCurrentUrl(), (CharSequence)this.getPage().getUrl()));
        this.checker.contains("Page URL contains text", this.getPage().getUrl(), this.getPage().getBrowser().actions().getCurrentUrl(), new String[0]);
    }

    @Override
    public void setWaiter(ElementWaiter waiter) {
        this.waiter = waiter;
    }

    @Override
    public void setChecker(Verifier checker) {
        this.checker = checker;
    }

    @Override
    public Verifier getChecker() {
        return this.checker;
    }
}

