/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.page;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import ru.mk.pump.commons.interfaces.StrictInfo;
import ru.mk.pump.commons.reporter.Reporter;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.web.browsers.Browser;
import ru.mk.pump.web.browsers.Browsers;
import ru.mk.pump.web.common.AbstractItemsManager;
import ru.mk.pump.web.common.pageobject.PumpElementAnnotations;
import ru.mk.pump.web.page.BasePage;
import ru.mk.pump.web.page.api.PageLoader;
import ru.mk.pump.web.utils.WebReporter;

public class PageManager
extends AbstractItemsManager<BasePage> {
    private final PageLoader pageLoader;

    public PageManager(Browsers browsers, Reporter reporter, PageLoader pageLoader, String ... packagesName) {
        super(browsers, reporter, packagesName);
        this.pageLoader = pageLoader;
    }

    public PageManager(Browsers browsers, String ... packagesName) {
        this(browsers, WebReporter.getReporter(), (PageLoader)null, packagesName);
    }

    @Override
    protected BasePage newInstance(Constructor<? extends BasePage> constructor, Class<? extends BasePage> itemClass) throws ReflectiveOperationException {
        if (constructor.getParameterCount() == 2) {
            return constructor.newInstance(this.getBrowsers().get(), this.getReporter());
        }
        return constructor.newInstance(this.getBrowsers().get());
    }

    @Override
    protected Constructor<? extends BasePage> findConstructor(Class<? extends BasePage> itemClass) throws ReflectiveOperationException {
        Constructor res = ConstructorUtils.getAccessibleConstructor(itemClass, (Class[])new Class[]{Browsers.class, Reporter.class});
        if (res == null) {
            return itemClass.getConstructor(Browser.class);
        }
        return res;
    }

    @Override
    protected BasePage afterItemCreate(BasePage itemInstance) {
        BasePage res = this.handleAnnotations(itemInstance);
        if (this.pageLoader != null) {
            res.setPageLoader(this.pageLoader);
        }
        return res;
    }

    @Override
    protected boolean findFilter(String pageName, Class<? extends BasePage> itemClass) {
        PumpElementAnnotations annotations = new PumpElementAnnotations(itemClass);
        return annotations.getPageName().equalsIgnoreCase(pageName) || itemClass.getSimpleName().equals(pageName);
    }

    @Override
    protected Class<BasePage> getItemClass() {
        return BasePage.class;
    }

    protected BasePage handleAnnotations(BasePage page) {
        PumpElementAnnotations annotations = new PumpElementAnnotations(page.getClass());
        Strings.ifNotEmptyOrBlank((String)annotations.getPageName(), page::setName);
        Strings.ifNotEmptyOrBlank((String)annotations.getPageDescription(), page::setDescription);
        Strings.ifNotEmptyOrBlank((String)annotations.getPageBaseUrl(), page::setBaseUrl);
        Strings.ifNotEmptyOrBlank((String)annotations.getPageResource(), page::setResourcePath);
        return page;
    }

    @Override
    public Map<String, String> getInfo() {
        return StrictInfo.infoFromSuper((StrictInfo)this, super.getInfo()).put("pageLoader", Strings.toString((Object)this.pageLoader)).build();
    }

    @Override
    public String toString() {
        return "PageManager(super=" + super.toString() + ", pageLoader=" + this.pageLoader + ")";
    }
}

