/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.mk.pump.commons.exception.PumpException;
import ru.mk.pump.commons.exception.PumpMessage;
import ru.mk.pump.commons.exception.UtilException;
import ru.mk.pump.commons.interfaces.StrictInfo;
import ru.mk.pump.commons.utils.HttpClients;
import ru.mk.pump.commons.utils.Strings;
import ru.mk.pump.web.browsers.Browser;

public class DownloadHelper {
    private static final Logger log = LoggerFactory.getLogger(DownloadHelper.class);
    private final Browser browser;
    private final Path downloadDir;

    public DownloadHelper(Browser browser) {
        this.browser = browser;
        this.downloadDir = browser.downloads().getDownloadDir();
    }

    public String download(String urlString) {
        HttpClient httpClient = HttpClients.newHttpClientNoSSL();
        HttpGet request = new HttpGet(this.getURI(urlString));
        request.setHeader("Cookie", this.getCookies());
        Path finalPath = this.downloadDir.resolve(this.getFullFileName(urlString));
        if (Files.exists(finalPath, new LinkOption[0])) {
            finalPath = this.downloadDir.resolve(this.getFullFileName(urlString) + UUID.randomUUID().toString());
        }
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw this.exception(String.format("Request has been executed with code '%s'", response.getStatusLine().getStatusCode()), urlString, null);
            }
            FileUtils.copyInputStreamToFile((InputStream)response.getEntity().getContent(), (File)finalPath.toFile());
        }
        catch (IOException e) {
            throw this.exception("HttpClient error", urlString, e);
        }
        return finalPath.toString();
    }

    private String getCookies() {
        String result = this.browser.getDriver().manage().getCookies().stream().map(cookie -> cookie.getName() + "=" + cookie.getValue()).collect(Collectors.joining("; "));
        log.debug("[DOWNLOAD-HELPER] Cookies from WebDriver : " + result);
        return result;
    }

    private String getFullFileName(String urlString) {
        String[] paths = urlString.split("/");
        return paths[paths.length - 1];
    }

    private URI getURI(String urlString) {
        try {
            URI result = new URI(urlString);
            log.debug("[DOWNLOAD-HELPER] URI : " + result);
            return result;
        }
        catch (Exception e) {
            throw this.exception("Cannot get URL", urlString, e);
        }
    }

    private UtilException exception(String message, String urlString, Throwable throwable) {
        String finalMessage = "[DOWNLOAD-HELPER] Cannot finish download ." + message;
        throw new PumpException(new PumpMessage(finalMessage).withDesc(Strings.space((String[])new String[]{"URL :", urlString, "Download to :", this.downloadDir.toString()})).addExtraInfo((StrictInfo)this.browser), throwable);
    }
}

