/*
 * Decompiled with CFR 0.152.
 */
package ru.mk.pump.web.utils;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;
import ru.mk.pump.commons.interfaces.PrettyPrinter;
import ru.mk.pump.commons.utils.Strings;

public final class TestVars
implements PrettyPrinter {
    public static final String RESULT = "result";
    public static final String LAST_PUT = "last";
    private final Map<String, Object> sourceMap;

    private TestVars(Map<String, Object> sourceMap) {
        this.sourceMap = new HashMap<String, Object>(sourceMap);
    }

    private TestVars() {
        this(Maps.newHashMap());
    }

    @NonNull
    public static TestVars of(@NonNull String key, @Nullable Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        return new TestVars().put(key, value);
    }

    @NonNull
    public static TestVars of(@NonNull Map<String, Object> sourceMap) {
        if (sourceMap == null) {
            throw new NullPointerException("sourceMap is marked @NonNull but is null");
        }
        return new TestVars(sourceMap);
    }

    @NonNull
    public static TestVars of() {
        return new TestVars();
    }

    @NonNull
    public TestVars put(@NonNull String key, @Nullable Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        this.sourceMap.put(key, value);
        this.sourceMap.put(LAST_PUT, value);
        return this;
    }

    @NonNull
    public TestVars putResult(@Nullable Object value) {
        this.sourceMap.put(RESULT, value);
        return this;
    }

    @Nullable
    public Object getResult() {
        return this.sourceMap.get(RESULT);
    }

    @Nullable
    public Object getLastPut() {
        return this.sourceMap.get(LAST_PUT);
    }

    @Nullable
    public Object get(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        return this.sourceMap.get(key);
    }

    @Nullable
    public Object get(@NonNull String key, @Nullable String defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        return this.sourceMap.getOrDefault(key, defaultValue);
    }

    public boolean has(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked @NonNull but is null");
        }
        return this.sourceMap.containsKey(key);
    }

    @NonNull
    public Map<String, Object> asMap() {
        return ImmutableMap.copyOf(this.sourceMap);
    }

    public String toPrettyString() {
        return Strings.toPrettyString(this.sourceMap);
    }

    public String toString() {
        return "TestVars(sourceMap=" + this.sourceMap + ")";
    }
}

